/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.wealdtech.DataError;
import com.wealdtech.jackson.WealdMapper;
import com.wealdtech.utils.RequestHint;
import com.wealdtech.utils.messaging.MessageObjects;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageObjectsDeserializer
extends StdDeserializer<MessageObjects<?>> {
    private static final long serialVersionUID = -8937155316970465927L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageObjectsDeserializer.class);

    public MessageObjectsDeserializer() {
        super(MessageObjects.class);
    }

    public MessageObjects<? extends Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Class<?> objClass;
        RequestHint hint;
        jp.nextToken();
        String fieldName = jp.getCurrentName();
        if (!"userid".equals(fieldName)) {
            throw new IOException("Unexpected key \"" + fieldName + "\"; expected userid");
        }
        jp.nextToken();
        Long userId = Long.parseLong(jp.getText());
        jp.nextToken();
        fieldName = jp.getCurrentName();
        if ("hint".equals(fieldName)) {
            jp.nextToken();
            hint = (RequestHint)WealdMapper.getMapper().readValue(jp, RequestHint.class);
            jp.nextToken();
        } else {
            hint = null;
        }
        fieldName = jp.getCurrentName();
        if (!"_type".equals(fieldName)) {
            throw new IOException("Unexpected key \"" + fieldName + "\"; expected _type");
        }
        jp.nextToken();
        String typeStr = jp.getText();
        try {
            objClass = Class.forName(typeStr);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.error("MessageObjects has unknown class: \"{}\"", (Object)typeStr);
            throw new IOException("MessageObjects has unknown class: \"" + typeStr + "\"", cnfe);
        }
        jp.nextToken();
        fieldName = jp.getCurrentName();
        Object prior = null;
        if ("prior".equals(fieldName)) {
            jp.nextToken();
            prior = WealdMapper.getMapper().readValue(jp, objClass);
            jp.nextToken();
            fieldName = jp.getCurrentName();
        }
        Object current = null;
        if ("current".equals(fieldName)) {
            jp.nextToken();
            current = WealdMapper.getMapper().readValue(jp, objClass);
        }
        try {
            return new MessageObjects<Object>(userId, hint, prior, current);
        }
        catch (DataError de) {
            LOGGER.error("Failed to instantiate MessageObjects: \"" + de.getLocalizedMessage() + "\"");
            throw new IOException("Failed to instantiate MessageObjects", de);
        }
    }
}

