/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.wealdtech.utils.messaging.MessageObjects;
import java.io.IOException;

public class MessageObjectsSerializer
extends StdSerializer<MessageObjects<? extends Object>> {
    public MessageObjectsSerializer() {
        super(MessageObjects.class, true);
    }

    public void serialize(MessageObjects<? extends Object> mo, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        provider.defaultSerializeField("userid", (Object)mo.getUserId(), jgen);
        if (mo.getHint() != null) {
            provider.defaultSerializeField("hint", (Object)mo.getHint(), jgen);
        }
        provider.defaultSerializeField("_type", (Object)mo.getType().getName(), jgen);
        if (mo.getPrior() != null) {
            jgen.writeObjectField("prior", mo.getPrior());
        }
        if (mo.getCurrent() != null) {
            jgen.writeObjectField("current", mo.getCurrent());
        }
        jgen.writeEndObject();
    }

    public void serializeWithType(MessageObjects<? extends Object> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForScalar(value, jgen, MessageObjects.class);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }
}

