/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.joda.time.Period;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodDeserializer
extends JsonDeserializer<Period> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodDeserializer.class);
    private static PeriodFormatter formatter = ISOPeriodFormat.standard();

    public Period deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        Period result = null;
        try {
            result = formatter.parsePeriod(node.textValue());
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn("Attempt to deserialize invalid period {}", (Object)node.textValue());
            throw new IOException("Invalid period value", iae);
        }
        return result;
    }
}

