/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.wealdtech.TriVal;
import java.io.IOException;

public class TriValDeserializer
extends StdDeserializer<TriVal<?>> {
    private static final long serialVersionUID = -2470822369451022310L;
    private final JavaType _referenceType;

    public TriValDeserializer(JavaType valueType) {
        super(valueType);
        this._referenceType = valueType.containedType(0);
    }

    public TriVal<?> getNullValue() {
        return TriVal.absent();
    }

    public TriVal<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() == JsonToken.VALUE_STRING && jp.getText().length() == 0) {
            return TriVal.clear();
        }
        Object reference = ctxt.findRootValueDeserializer(this._referenceType).deserialize(jp, ctxt);
        return TriVal.of((Object)reference);
    }
}

