/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.net.InetAddress;
import java.util.Comparator;
import javax.annotation.Nonnull;

public class RequestHint
implements Comparable<RequestHint> {
    private final Optional<Integer> latitude;
    private final Optional<Integer> longitude;
    private final Optional<Float> altitude;
    private final Optional<InetAddress> address;
    private final Optional<String> userAgent;

    @JsonCreator
    public RequestHint(@JsonProperty(value="latitude") Integer latitude, @JsonProperty(value="longitude") Integer longitude, @JsonProperty(value="altitude") Float altitude, @JsonProperty(value="address") InetAddress address, @JsonProperty(value="useragent") String userAgent) {
        this.latitude = Optional.fromNullable((Object)latitude);
        this.longitude = Optional.fromNullable((Object)longitude);
        this.altitude = Optional.fromNullable((Object)altitude);
        this.address = Optional.fromNullable((Object)address);
        this.userAgent = Optional.fromNullable((Object)userAgent);
    }

    public Optional<Integer> getLatitude() {
        return this.latitude;
    }

    public Optional<Integer> getLongitude() {
        return this.longitude;
    }

    public Optional<Float> getAltitude() {
        return this.altitude;
    }

    public Optional<InetAddress> getAddress() {
        return this.address;
    }

    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("latitude", this.latitude.orNull()).add("longitude", this.longitude.orNull()).add("altitude", this.altitude.orNull()).add("address", this.address.orNull()).add("userAgent", this.userAgent.orNull()).omitNullValues().toString();
    }

    public boolean equals(Object that) {
        return that instanceof RequestHint && this.compareTo((RequestHint)that) == 0;
    }

    @Override
    public int compareTo(@Nonnull RequestHint that) {
        return ComparisonChain.start().compare(this.latitude.orNull(), that.latitude.orNull(), (Comparator)Ordering.natural().nullsFirst()).compare(this.longitude.orNull(), that.longitude.orNull(), (Comparator)Ordering.natural().nullsFirst()).compare(this.altitude.orNull(), that.altitude.orNull(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.address.toString(), (Object)that.address.toString(), (Comparator)Ordering.natural().nullsFirst()).compare(this.userAgent.orNull(), that.userAgent.orNull(), (Comparator)Ordering.natural().nullsFirst()).result();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.latitude, this.longitude, this.altitude, this.address, this.userAgent});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RequestHint prior) {
        return new Builder(prior);
    }

    public static class Builder {
        private Integer latitude;
        private Integer longitude;
        private Float altitude;
        private InetAddress address;
        private String userAgent;

        public Builder() {
        }

        public Builder(RequestHint prior) {
            this.latitude = (Integer)prior.latitude.orNull();
            this.longitude = (Integer)prior.longitude.orNull();
            this.altitude = (Float)prior.altitude.orNull();
            this.address = (InetAddress)prior.address.orNull();
            this.userAgent = (String)prior.userAgent.orNull();
        }

        public Builder latitude(Integer latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder latitude(float latitude) {
            this.latitude = (int)(latitude * 1000000.0f);
            return this;
        }

        public Builder latitude(double latitude) {
            this.latitude = (int)(latitude * 1000000.0);
            return this;
        }

        public Builder longitude(Integer longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder longitude(float longitude) {
            this.longitude = (int)(longitude * 1000000.0f);
            return this;
        }

        public Builder longitude(double longitude) {
            this.longitude = (int)(longitude * 1000000.0);
            return this;
        }

        public Builder altitude(float altitude) {
            this.altitude = Float.valueOf(altitude);
            return this;
        }

        public Builder address(InetAddress address) {
            this.address = address;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public RequestHint build() {
            return new RequestHint(this.latitude, this.longitude, this.altitude, this.address, this.userAgent);
        }
    }
}

