/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.utils.messaging;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wealdtech.Preconditions;
import com.wealdtech.utils.RequestHint;
import java.io.Serializable;

public class MessageObjects<T>
implements Serializable {
    private static final long serialVersionUID = 6306799063373268531L;
    private final transient Long userId;
    private final transient RequestHint hint;
    private final transient T prior;
    private final transient T current;

    @JsonCreator
    public MessageObjects(@JsonProperty(value="userid") Long userId, @JsonProperty(value="hint") RequestHint hint, @JsonProperty(value="prior") T prior, @JsonProperty(value="current") T current) {
        Preconditions.checkState((prior != null || current != null ? 1 : 0) != 0, (Object)"At least one object must be present");
        this.userId = userId;
        this.hint = hint;
        this.prior = prior;
        this.current = current;
    }

    public Long getUserId() {
        return this.userId;
    }

    public RequestHint getHint() {
        return this.hint;
    }

    public T getPrior() {
        return this.prior;
    }

    public T getCurrent() {
        return this.current;
    }

    public Class<? extends Object> getType() {
        Class<?> retclass = this.prior == null ? this.current.getClass() : this.prior.getClass();
        return retclass;
    }
}

