/*
 * Decompiled with CFR 0.152.
 */
package com.webank.blockchain.hsm.crypto;

import com.webank.blockchain.hsm.crypto.sdf.AlgorithmType;
import com.webank.blockchain.hsm.crypto.sdf.SDF;
import com.webank.blockchain.hsm.crypto.sdf.SDFCryptoResult;
import com.webank.blockchain.hsm.crypto.utils.Hex;
import org.junit.Assert;
import org.junit.Test;

public class SDFTest {
    @Test
    public void hashTest() {
        byte[] message = new byte[]{97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100};
        byte[] stdResult = new byte[]{-34, -66, -97, -7, 34, 117, -72, -95, 56, 96, 72, -119, -63, -114, 90, 77, 111, -37, 112, -27, 56, 126, 87, 101, 41, 61, -53, -93, -100, 12, 87, 50};
        System.out.println("*********Hash*********");
        SDFCryptoResult hashResult = SDF.Hash(null, AlgorithmType.SM3, Hex.toHexString(message));
        Assert.assertNull((Object)hashResult.getSdfErrorMessage());
        Assert.assertEquals((Object)hashResult.getHash(), (Object)Hex.toHexString(stdResult));
        System.out.println("*********KeyGen*********");
        SDFCryptoResult keGenResult = SDF.KeyGen(AlgorithmType.SM2);
        Assert.assertNull((Object)keGenResult.getSdfErrorMessage());
        System.out.println("*********Sign*********");
        SDFCryptoResult signResult = SDF.Sign(keGenResult.getPrivateKey(), AlgorithmType.SM2, hashResult.getHash());
        Assert.assertNull((Object)signResult.getSdfErrorMessage());
        System.out.println("*********Verify*********");
        SDFCryptoResult verifyResult = SDF.Verify(keGenResult.getPublicKey(), AlgorithmType.SM2, hashResult.getHash(), signResult.getSignature());
        Assert.assertNull((Object)verifyResult.getSdfErrorMessage());
        Assert.assertEquals((Object)verifyResult.getResult(), (Object)true);
        System.out.println("*********SignWithInnerKey*********");
        SDFCryptoResult signInResult = SDF.SignWithInternalKey(1L, "123456", AlgorithmType.SM2, hashResult.getHash());
        Assert.assertNull((Object)signInResult.getSdfErrorMessage());
        System.out.println("*********VerifyWithInnerKey*********");
        SDFCryptoResult verifyInResult = SDF.VerifyWithInternalKey(1L, AlgorithmType.SM2, hashResult.getHash(), signInResult.getSignature());
        Assert.assertNull((Object)verifyInResult.getSdfErrorMessage());
        Assert.assertEquals((Object)verifyInResult.getResult(), (Object)true);
        System.out.println("*********GetInternalPublicKey*********");
        SDFCryptoResult exportKeyResult = SDF.ExportInternalPublicKey(1L, AlgorithmType.SM2);
        Assert.assertNull((Object)verifyInResult.getSdfErrorMessage());
        if (exportKeyResult.getSdfErrorMessage() != null) {
            System.out.println(exportKeyResult.getSdfErrorMessage());
        } else {
            System.out.println(exportKeyResult.getPublicKey());
        }
    }
}

