/*
 * Decompiled with CFR 0.152.
 */
package com.webank.blockchain.hsm.crypto.utils;

import java.io.IOException;
import java.io.OutputStream;

public class HexEncoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int i;
        for (i = 0; i < this.decodingTable.length; ++i) {
            this.decodingTable[i] = -1;
        }
        for (i = 0; i < this.encodingTable.length; ++i) {
            this.decodingTable[this.encodingTable[i]] = (byte)i;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        for (int i = off; i < off + length; ++i) {
            int v = data[i] & 0xFF;
            out.write(this.encodingTable[v >>> 4]);
            out.write(this.encodingTable[v & 0xF]);
        }
        return length * 2;
    }

    private static boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int end;
        int outLen = 0;
        for (end = off + length; end > off && HexEncoder.ignore((char)data[end - 1]); --end) {
        }
        int i = off;
        while (i < end) {
            byte field2;
            while (i < end && HexEncoder.ignore((char)data[i])) {
                ++i;
            }
            byte field1 = this.decodingTable[data[i++]];
            while (i < end && HexEncoder.ignore((char)data[i])) {
                ++i;
            }
            if ((field1 | (field2 = this.decodingTable[data[i++]])) < 0) {
                throw new IOException("invalid characters encountered in Hex data");
            }
            out.write(field1 << 4 | field2 & 0xFF);
            ++outLen;
        }
        return outLen;
    }

    public int decode(String data, OutputStream out) throws IOException {
        int end;
        int length = 0;
        for (end = data.length(); end > 0 && HexEncoder.ignore(data.charAt(end - 1)); --end) {
        }
        int i = 0;
        while (i < end) {
            byte b2;
            while (i < end && HexEncoder.ignore(data.charAt(i))) {
                ++i;
            }
            byte b1 = this.decodingTable[data.charAt(i++)];
            while (i < end && HexEncoder.ignore(data.charAt(i))) {
                ++i;
            }
            if ((b1 | (b2 = this.decodingTable[data.charAt(i++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            out.write(b1 << 4 | b2 & 0xFF);
            ++length;
        }
        return length;
    }
}

