/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wecross.stub;

import java.util.Objects;

public class Path {
    private String zone;
    private String chain;
    private String resource;

    public static Path decode(String path) throws Exception {
        String[] sp = path.split("\\.");
        if (sp.length < 2) {
            throw new Exception("Decode path error: " + path);
        }
        for (String name : sp) {
            if (name != null && name.length() != 0) continue;
            throw new Exception("Decode path error: " + path);
        }
        Path obj = new Path();
        obj.setZone(sp[0]);
        obj.setChain(sp[1]);
        if (sp.length > 2) {
            obj.setResource(sp[2]);
        }
        return obj;
    }

    public Path() {
    }

    public Path(Path path) {
        this.zone = path.getZone();
        this.chain = path.getChain();
        this.resource = path.getResource();
    }

    public Path(String str) throws Exception {
        Path path = Path.decode(str);
        this.zone = path.zone;
        this.chain = path.chain;
        this.resource = path.resource;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getChain() {
        return this.chain;
    }

    public void setChain(String chain) {
        this.chain = chain;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path path = (Path)o;
        return Objects.equals(this.getZone(), path.getZone()) && Objects.equals(this.getChain(), path.getChain()) && Objects.equals(this.getResource(), path.getResource());
    }

    public int hashCode() {
        return Objects.hash(this.getZone(), this.getChain(), this.getResource());
    }

    public String toString() {
        if (Objects.nonNull(this.resource)) {
            return this.zone + "." + this.chain + "." + this.resource;
        }
        return this.zone + "." + this.chain;
    }

    public String toURI() {
        if (Objects.nonNull(this.resource)) {
            return this.zone + "/" + this.chain + "/" + this.resource;
        }
        return this.zone + "/" + this.chain;
    }
}

