/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wecross.stub;

public class TransactionException
extends Exception {
    private static final long serialVersionUID = 3754251446587995515L;
    private Integer errorCode;

    public TransactionException(Integer errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public boolean isSuccess() {
        return this.getErrorCode() == 0;
    }

    public static class Builder {
        public static TransactionException newSuccessException() {
            return new TransactionException(0, "Success");
        }

        public static TransactionException newInternalException(String message) {
            return new TransactionException(1001, message);
        }
    }

    public static class ErrorCode {
        public static final int SUCCESS = 0;
        public static final int REMOTE_QUERY_FAILED = 100;
        public static final int TIMEOUT = 200;
        public static final int ACCOUNT_ERRPR = 300;
        public static final int INTERNAL_ERROR = 1001;
    }
}

