/*
 * Copyright 2019 WeBank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.webank.wedatasphere.linkis.protocol.engine

import com.webank.wedatasphere.linkis.protocol.RetryableProtocol

case class RequestUserEngineKill(ticketId: String, creator: String, user: String, properties: Map[String, String]) extends RetryableProtocol
case class ResponseUserEngineKill(ticketId: String, status: String, message: String)
object ResponseUserEngineKill{
  val Success = "Success"
  val Error = "Error"
}