/*
 * Copyright 2019 WeBank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.webank.wedatasphere.linkis.protocol.utils

import javafx.beans.binding.LongExpression

/**
  * created by enjoyyin on 2018/11/8
  * Description:
  */
object ZuulEntranceUtils {



  def parseExecID(longExecID:String):Array[String] = {
    //Add creator to execID while old code is compatible(添加creator到execID,同时老代码兼容)
    if(isNumberic(longExecID.substring(0, 6))){
      val creatorLength = Integer.parseInt(longExecID.substring(0,2))
      val executeLength = Integer.parseInt(longExecID.substring(2,4))
      val instanceLength = Integer.parseInt(longExecID.substring(4,6))
      val creator = longExecID.substring(6, 6 + creatorLength)
      val executeApplicationName = longExecID.substring(6 + creatorLength, 6 + creatorLength + executeLength)
      val instance = longExecID.substring(6 + creatorLength + executeLength, 6 + creatorLength + executeLength + instanceLength)
      val shortExecID = longExecID.substring(6 + creatorLength + executeLength + instanceLength, longExecID.length)
      return Array(creator, executeApplicationName, instance, shortExecID)
    }
    val executeLength = Integer.parseInt(longExecID.substring(0,2))
    val instanceLength = Integer.parseInt(longExecID.substring(2,4))
    val executeApplicationName:String = longExecID.substring(4, 4 + executeLength)
    val instance:String = longExecID.substring(4 + executeLength, 4 + executeLength + instanceLength)
    val shortExecID:String = longExecID.substring(4 + executeLength + instanceLength, longExecID.length)
    Array[String](executeApplicationName, instance, shortExecID)
  }


  private def isNumberic(s:String):Boolean = {
    s.toCharArray foreach {
      c => if (c < 48 || c >57) return false
    }
    true
  }

  /**
    *
    * @param shortExecID ExecID generated by the scheduler, such as IDE_neiljianliu_0(scheduler生成的ExecID, 如 IDE_neiljianliu_0)
    * @param executeApplicationName {dd}{dd}${executeApplicationName}${instance}${shortExecID}
    * @return
    */
  @Deprecated
  def generateExecID(shortExecID:String, executeApplicationName:String, instance:String):String = {
    val executeLength = getLengthStr(executeApplicationName)
    val instanceLength = getLengthStr(instance)
    if (shortExecID.split("_").length == 3){
      //Backward compatible(向下兼容)
      val creator = shortExecID.split("_")(0)
      val creatorLength = getLengthStr(creator)
      return creatorLength + executeLength + instanceLength + creator + executeApplicationName + instance + shortExecID
    }
    executeLength + instanceLength + executeApplicationName + instance + shortExecID
  }


  def generateExecID(shortExecID:String, executeApplicationName:String, instance:String, creator:String):String = {
    val creatorLength = getLengthStr(creator)
    val executeLength = getLengthStr(executeApplicationName)
    val instanceLength = getLengthStr(instance)
    creatorLength + executeLength + instanceLength + creator + executeApplicationName + instance + shortExecID
  }




  private def getLengthStr(string:String):String = {
    val length = string.length
    if (length >= 10) String.valueOf(length) else "0" + String.valueOf(length)
  }

  def main(args: Array[String]): Unit = {

  }

}
