/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest;

import com.webauthn4j.appattest.data.DCAssertion;
import com.webauthn4j.appattest.data.DCAssertionData;
import com.webauthn4j.appattest.data.DCAssertionParameters;
import com.webauthn4j.appattest.data.DCAssertionRequest;
import com.webauthn4j.appattest.verifier.DCAssertionDataVerifier;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.CustomCoreAuthenticationVerifier;
import com.webauthn4j.verifier.exception.VerificationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeviceCheckAssertionManager {
    private final AuthenticatorDataConverter authenticatorDataConverter;
    private final DCAssertionDataVerifier dcAssertionDataValidator;
    private final CborConverter cborConverter;

    public DeviceCheckAssertionManager(@NotNull List<CustomCoreAuthenticationVerifier> customAuthenticationValidators, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(customAuthenticationValidators, (String)"customAuthenticationValidators must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.dcAssertionDataValidator = new DCAssertionDataVerifier(customAuthenticationValidators);
        this.authenticatorDataConverter = new AuthenticatorDataConverter(objectConverter);
        this.cborConverter = objectConverter.getCborConverter();
    }

    public DeviceCheckAssertionManager(@NotNull List<CustomCoreAuthenticationVerifier> customAuthenticationValidators) {
        this(customAuthenticationValidators, new ObjectConverter());
    }

    public DeviceCheckAssertionManager() {
        this(Collections.emptyList(), new ObjectConverter());
    }

    @NotNull
    public DCAssertionData parse(@NotNull DCAssertionRequest dcAssertionRequest) throws DataConversionException {
        AssertUtil.notNull((Object)dcAssertionRequest, (String)"dcAssertionRequest must not be null");
        byte[] credentialId = dcAssertionRequest.getKeyId();
        DCAssertion assertion = (DCAssertion)this.cborConverter.readValue(dcAssertionRequest.getAssertion(), DCAssertion.class);
        byte[] authenticatorDataBytes = assertion == null ? null : assertion.getAuthenticatorData();
        AuthenticatorData authenticatorData = authenticatorDataBytes == null ? null : this.authenticatorDataConverter.convert(authenticatorDataBytes);
        byte[] clientDataHash = dcAssertionRequest.getClientDataHash();
        byte[] signature = assertion == null ? null : assertion.getSignature();
        return new DCAssertionData(credentialId, (AuthenticatorData<AuthenticationExtensionAuthenticatorOutput>)authenticatorData, authenticatorDataBytes, clientDataHash, signature);
    }

    @NotNull
    public DCAssertionData verify(@NotNull DCAssertionRequest dcAssertionRequest, @NotNull DCAssertionParameters dcAssertionParameters) throws DataConversionException, VerificationException {
        DCAssertionData dcAssertionData = this.parse(dcAssertionRequest);
        return this.verify(dcAssertionData, dcAssertionParameters);
    }

    @Deprecated
    @NotNull
    public DCAssertionData validate(@NotNull DCAssertionRequest dcAssertionRequest, @NotNull DCAssertionParameters dcAssertionParameters) throws DataConversionException, VerificationException {
        return this.verify(dcAssertionRequest, dcAssertionParameters);
    }

    @NotNull
    public DCAssertionData verify(@NotNull DCAssertionData dcAssertionData, @NotNull DCAssertionParameters dcAssertionParameters) throws VerificationException {
        this.getDCAssertionDataValidator().verify(dcAssertionData, dcAssertionParameters);
        return dcAssertionData;
    }

    @Deprecated
    @NotNull
    public DCAssertionData validate(@NotNull DCAssertionData dcAssertionData, @NotNull DCAssertionParameters dcAssertionParameters) throws VerificationException {
        return this.verify(dcAssertionData, dcAssertionParameters);
    }

    @NotNull
    public DCAssertionDataVerifier getDCAssertionDataValidator() {
        return this.dcAssertionDataValidator;
    }
}

