/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async;

import com.fasterxml.jackson.core.type.TypeReference;
import com.webauthn4j.async.verifier.AuthenticationDataAsyncVerifier;
import com.webauthn4j.async.verifier.CustomAuthenticationAsyncVerifier;
import com.webauthn4j.converter.AuthenticationExtensionsClientOutputsConverter;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.AuthenticatorAssertionResponse;
import com.webauthn4j.data.PublicKeyCredential;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CompletionStageUtil;
import com.webauthn4j.verifier.exception.VerificationException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthnAuthenticationAsyncManager {
    private final Logger logger = LoggerFactory.getLogger(WebAuthnAuthenticationAsyncManager.class);
    private final CollectedClientDataConverter collectedClientDataConverter;
    private final AuthenticatorDataConverter authenticatorDataConverter;
    private final AuthenticationExtensionsClientOutputsConverter authenticationExtensionsClientOutputsConverter;
    private final AuthenticationDataAsyncVerifier authenticationDataAsyncVerifier;
    private final ObjectConverter objectConverter;

    public WebAuthnAuthenticationAsyncManager(@NotNull List<CustomAuthenticationAsyncVerifier> customAuthenticationAsyncVerifiers, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(customAuthenticationAsyncVerifiers, (String)"customAuthenticationAsyncVerifiers must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.authenticationDataAsyncVerifier = new AuthenticationDataAsyncVerifier(customAuthenticationAsyncVerifiers);
        this.collectedClientDataConverter = new CollectedClientDataConverter(objectConverter);
        this.authenticatorDataConverter = new AuthenticatorDataConverter(objectConverter);
        this.authenticationExtensionsClientOutputsConverter = new AuthenticationExtensionsClientOutputsConverter(objectConverter);
        this.objectConverter = objectConverter;
    }

    public WebAuthnAuthenticationAsyncManager(@NotNull List<CustomAuthenticationAsyncVerifier> customAuthenticationVerifiers) {
        this(customAuthenticationVerifiers, new ObjectConverter());
    }

    public WebAuthnAuthenticationAsyncManager() {
        this(Collections.emptyList(), new ObjectConverter());
    }

    public CompletionStage<AuthenticationData> parse(String authenticationResponseJSON) {
        return CompletionStageUtil.supply(() -> (PublicKeyCredential)this.objectConverter.getJsonConverter().readValue(authenticationResponseJSON, (TypeReference)new TypeReference<PublicKeyCredential<AuthenticatorAssertionResponse, AuthenticationExtensionClientOutput>>(){})).thenApply(publicKeyCredential -> {
            byte[] credentialId = publicKeyCredential.getRawId();
            byte[] userHandle = ((AuthenticatorAssertionResponse)publicKeyCredential.getResponse()).getUserHandle();
            byte[] clientDataBytes = ((AuthenticatorAssertionResponse)publicKeyCredential.getResponse()).getClientDataJSON();
            CollectedClientData collectedClientData = clientDataBytes == null ? null : this.collectedClientDataConverter.convert(clientDataBytes);
            byte[] authenticatorDataBytes = ((AuthenticatorAssertionResponse)publicKeyCredential.getResponse()).getAuthenticatorData();
            AuthenticatorData authenticatorData = authenticatorDataBytes == null ? null : this.authenticatorDataConverter.convert(authenticatorDataBytes);
            AuthenticationExtensionsClientOutputs clientExtensions = publicKeyCredential.getClientExtensionResults();
            byte[] signature = ((AuthenticatorAssertionResponse)publicKeyCredential.getResponse()).getSignature();
            return new AuthenticationData(credentialId, userHandle, authenticatorData, authenticatorDataBytes, collectedClientData, clientDataBytes, clientExtensions, signature);
        });
    }

    @NotNull
    public CompletionStage<AuthenticationData> parse(@NotNull AuthenticationRequest authenticationRequest) {
        return CompletionStageUtil.supply(() -> {
            AssertUtil.notNull((Object)authenticationRequest, (String)"authenticationRequest must not be null");
            this.logger.trace("Parse: {}", (Object)authenticationRequest);
            byte[] credentialId = authenticationRequest.getCredentialId();
            byte[] signature = authenticationRequest.getSignature();
            byte[] userHandle = authenticationRequest.getUserHandle();
            byte[] clientDataBytes = authenticationRequest.getClientDataJSON();
            CollectedClientData collectedClientData = clientDataBytes == null ? null : this.collectedClientDataConverter.convert(clientDataBytes);
            byte[] authenticatorDataBytes = authenticationRequest.getAuthenticatorData();
            AuthenticatorData authenticatorData = authenticatorDataBytes == null ? null : this.authenticatorDataConverter.convert(authenticatorDataBytes);
            AuthenticationExtensionsClientOutputs clientExtensions = authenticationRequest.getClientExtensionsJSON() == null ? null : this.authenticationExtensionsClientOutputsConverter.convert(authenticationRequest.getClientExtensionsJSON());
            return new AuthenticationData(credentialId, userHandle, authenticatorData, authenticatorDataBytes, collectedClientData, clientDataBytes, clientExtensions, signature);
        });
    }

    @NotNull
    public CompletionStage<AuthenticationData> verify(@NotNull String authenticationResponseJSON, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, VerificationException {
        return this.parse(authenticationResponseJSON).thenCompose(authenticationData -> this.verify((AuthenticationData)authenticationData, authenticationParameters));
    }

    @NotNull
    public CompletionStage<AuthenticationData> verify(@NotNull AuthenticationRequest authenticationRequest, @NotNull AuthenticationParameters authenticationParameters) {
        return this.parse(authenticationRequest).thenCompose(authenticationData -> this.verify((AuthenticationData)authenticationData, authenticationParameters));
    }

    @NotNull
    public CompletionStage<AuthenticationData> verify(@NotNull AuthenticationData authenticationData, @NotNull AuthenticationParameters authenticationParameters) {
        this.logger.trace("Verify: {}, {}", (Object)authenticationData, (Object)authenticationParameters);
        return this.authenticationDataAsyncVerifier.verify(authenticationData, authenticationParameters);
    }

    @NotNull
    public AuthenticationDataAsyncVerifier getAuthenticationDataAsyncVerifier() {
        return this.authenticationDataAsyncVerifier;
    }
}

