/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TokenBindingStatus {
    public static final TokenBindingStatus PRESENT = new TokenBindingStatus("present");
    public static final TokenBindingStatus SUPPORTED = new TokenBindingStatus("supported");
    public static final TokenBindingStatus NOT_SUPPORTED = new TokenBindingStatus("not-supported");
    private final String value;

    private TokenBindingStatus(@NotNull String value) {
        this.value = value;
    }

    @JsonCreator
    @NotNull
    public static TokenBindingStatus create(@NotNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        switch (value) {
            case "present": {
                return PRESENT;
            }
            case "supported": {
                return SUPPORTED;
            }
            case "not-supported": {
                return NOT_SUPPORTED;
            }
        }
        return new TokenBindingStatus(value);
    }

    @JsonValue
    @NotNull
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenBindingStatus that = (TokenBindingStatus)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

