/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.CoreRegistrationData;
import com.webauthn4j.data.CoreRegistrationParameters;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AttestationVerifier;
import com.webauthn4j.verifier.AuthenticatorExtensionVerifier;
import com.webauthn4j.verifier.CoreRegistrationObject;
import com.webauthn4j.verifier.CustomCoreRegistrationVerifier;
import com.webauthn4j.verifier.attestation.statement.AttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import com.webauthn4j.verifier.exception.NotAllowedAlgorithmException;
import com.webauthn4j.verifier.exception.UserNotPresentException;
import com.webauthn4j.verifier.exception.UserNotVerifiedException;
import com.webauthn4j.verifier.internal.BeanAssertUtil;
import com.webauthn4j.verifier.internal.RpIdHashVerifier;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CoreRegistrationDataVerifier {
    private final AuthenticatorExtensionVerifier authenticatorExtensionVerifier = new AuthenticatorExtensionVerifier();
    private final AttestationVerifier attestationVerifier;
    private final List<CustomCoreRegistrationVerifier> customRegistrationVerifiers;

    public CoreRegistrationDataVerifier(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier, @NotNull List<CustomCoreRegistrationVerifier> customRegistrationVerifiers, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(attestationStatementVerifiers, (String)"attestationStatementVerifiers must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessVerifier, (String)"certPathTrustworthinessVerifier must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessVerifier, (String)"selfAttestationTrustworthinessVerifier must not be null");
        AssertUtil.notNull(customRegistrationVerifiers, (String)"customRegistrationVerifiers must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.attestationVerifier = new AttestationVerifier(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier);
        this.customRegistrationVerifiers = customRegistrationVerifiers;
    }

    public void verify(@NotNull CoreRegistrationData registrationData, @NotNull CoreRegistrationParameters registrationParameters) {
        BeanAssertUtil.validate(registrationData);
        AssertUtil.notNull((Object)registrationParameters, (String)"registrationParameters must not be null");
        AttestationObject attestationObject = registrationData.getAttestationObject();
        this.verifyAuthenticatorDataField(attestationObject.getAuthenticatorData());
        CoreServerProperty serverProperty = registrationParameters.getServerProperty();
        CoreRegistrationObject registrationObject = this.createCoreRegistrationObject(registrationData, registrationParameters);
        AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData = attestationObject.getAuthenticatorData();
        COSEKey coseKey = authenticatorData.getAttestedCredentialData().getCOSEKey();
        this.verifyCOSEKey(coseKey);
        RpIdHashVerifier.verify(authenticatorData.getRpIdHash(), serverProperty);
        this.verifyUVUPFlags(authenticatorData, registrationParameters.isUserVerificationRequired(), registrationParameters.isUserPresenceRequired());
        COSEAlgorithmIdentifier alg = authenticatorData.getAttestedCredentialData().getCOSEKey().getAlgorithm();
        List<PublicKeyCredentialParameters> pubKeyCredParams = registrationParameters.getPubKeyCredParams();
        this.verifyAlg(alg, pubKeyCredParams);
        AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.authenticatorExtensionVerifier.verify(authenticationExtensionsAuthenticatorOutputs);
        this.attestationVerifier.verify(registrationObject);
        for (CustomCoreRegistrationVerifier customRegistrationVerifier : this.customRegistrationVerifiers) {
            customRegistrationVerifier.verify(registrationObject);
        }
    }

    void verifyAlg(COSEAlgorithmIdentifier alg, List<PublicKeyCredentialParameters> pubKeyCredParams) {
        if (pubKeyCredParams != null && pubKeyCredParams.stream().noneMatch(item -> item.getAlg().equals(alg))) {
            throw new NotAllowedAlgorithmException("alg not listed in options.pubKeyCredParams is used.");
        }
    }

    void verifyCOSEKey(COSEKey coseKey) {
        if (coseKey.getPublicKey() == null) {
            throw new ConstraintViolationException("coseKey doesn't contain public key");
        }
    }

    protected CoreRegistrationObject createCoreRegistrationObject(@NotNull CoreRegistrationData registrationData, @NotNull CoreRegistrationParameters registrationParameters) {
        return new CoreRegistrationObject(registrationData.getAttestationObject(), registrationData.getAttestationObjectBytes(), registrationData.getClientDataHash(), registrationParameters.getServerProperty());
    }

    void verifyAuthenticatorDataField(@NotNull AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() == null) {
            throw new ConstraintViolationException("attestedCredentialData must not be null on registration");
        }
    }

    void verifyUVUPFlags(@NotNull AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData, boolean isUserVerificationRequired, boolean isUserPresenceRequired) {
        if (isUserVerificationRequired && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Verifier is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        if (isUserPresenceRequired && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Verifier is configured to check user present, but UP flag in authenticatorData is not set.");
        }
    }

    @NotNull
    public List<CustomCoreRegistrationVerifier> getCustomRegistrationVerifiers() {
        return this.customRegistrationVerifiers;
    }
}

