/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticatorTransport {
    public static final AuthenticatorTransport USB = new AuthenticatorTransport("usb");
    public static final AuthenticatorTransport NFC = new AuthenticatorTransport("nfc");
    public static final AuthenticatorTransport BLE = new AuthenticatorTransport("ble");
    public static final AuthenticatorTransport HYBRID = new AuthenticatorTransport("hybrid");
    public static final AuthenticatorTransport INTERNAL = new AuthenticatorTransport("internal");
    private final String value;

    private AuthenticatorTransport(@NotNull String value) {
        this.value = value;
    }

    @NotNull
    public static AuthenticatorTransport create(@NotNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        return new AuthenticatorTransport(value);
    }

    @JsonCreator
    @NotNull
    static AuthenticatorTransport deserialize(@NotNull String value) throws InvalidFormatException {
        try {
            return AuthenticatorTransport.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AuthenticatorTransport.class);
        }
    }

    @JsonValue
    @NotNull
    public String getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorTransport that = (AuthenticatorTransport)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }
}

