/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.response.attestation.statement.Response;
import com.webauthn4j.util.jws.JWS;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class JWSDeserializer
extends StdDeserializer<JWS> {
    private JsonConverter jsonConverter;

    public JWSDeserializer(JsonConverter jsonConverter) {
        super(JWS.class);
        this.jsonConverter = jsonConverter;
    }

    public JWS deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        String str = new String(value, StandardCharsets.UTF_8);
        try {
            return JWS.parse(str, this.jsonConverter, Response.class);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "value is not valid as JWS", (Object)value, JWS.class);
        }
    }
}

