/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.attestation.statement;

import com.webauthn4j.response.attestation.statement.TPMUPublicId;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class RSAUnique
implements TPMUPublicId {
    private byte[] n;

    public RSAUnique(byte[] n) {
        this.n = n;
    }

    public byte[] getN() {
        return ArrayUtil.clone((byte[])this.n);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RSAUnique rsaUnique = (RSAUnique)o;
        return Arrays.equals(this.n, rsaUnique.n);
    }

    public int hashCode() {
        return Arrays.hashCode(this.n);
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this.n.length);
        buffer.put(UnsignedNumberUtil.toBytes((int)this.getN().length));
        buffer.put(this.getN());
        return buffer.array();
    }
}

