/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.response.WebAuthnAuthenticationContext;
import com.webauthn4j.response.WebAuthnRegistrationContext;
import com.webauthn4j.response.attestation.AttestationObject;
import com.webauthn4j.response.attestation.authenticator.AAGUID;
import com.webauthn4j.response.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.response.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.response.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.response.attestation.statement.AttestationStatement;
import com.webauthn4j.response.client.CollectedClientData;
import com.webauthn4j.response.client.TokenBinding;
import com.webauthn4j.response.extension.ExtensionOutput;
import com.webauthn4j.response.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.response.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.response.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.response.extension.client.ExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.validator.exception.BadRpIdException;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Map;

class BeanAssertUtil {
    private BeanAssertUtil() {
    }

    public static void validate(WebAuthnAuthenticationContext webAuthnAuthenticationContext) {
        if (webAuthnAuthenticationContext == null) {
            throw new ConstraintViolationException("webAuthnAuthenticationContext must not be null");
        }
        if (webAuthnAuthenticationContext.getCredentialId() == null) {
            throw new ConstraintViolationException("credentialId must not be null");
        }
        if (webAuthnAuthenticationContext.getClientDataJSON() == null) {
            throw new ConstraintViolationException("clientDataJSON must not be null");
        }
        if (webAuthnAuthenticationContext.getAuthenticatorData() == null) {
            throw new ConstraintViolationException("authenticatorData must not be null");
        }
        if (webAuthnAuthenticationContext.getSignature() == null) {
            throw new ConstraintViolationException("signature must not be null");
        }
        if (webAuthnAuthenticationContext.getServerProperty() == null) {
            throw new ConstraintViolationException("serverProperty must not be null");
        }
    }

    public static void validate(WebAuthnRegistrationContext webAuthnRegistrationContext) {
        if (webAuthnRegistrationContext == null) {
            throw new ConstraintViolationException("webAuthnRegistrationContext must not be null");
        }
        if (webAuthnRegistrationContext.getAttestationObject() == null) {
            throw new ConstraintViolationException("attestationObject must not be null");
        }
        if (webAuthnRegistrationContext.getClientDataJSON() == null) {
            throw new ConstraintViolationException("clientDataJSON must not be null");
        }
        if (webAuthnRegistrationContext.getServerProperty() == null) {
            throw new ConstraintViolationException("serverProperty must not be null");
        }
    }

    public static void validate(CollectedClientData collectedClientData) {
        if (collectedClientData == null) {
            throw new ConstraintViolationException("collectedClientData must not be null");
        }
        if (collectedClientData.getType() == null) {
            throw new ConstraintViolationException("type must not be null");
        }
        if (collectedClientData.getChallenge() == null) {
            throw new ConstraintViolationException("challenge must not be null");
        }
        if (collectedClientData.getOrigin() == null) {
            throw new ConstraintViolationException("origin must not be null");
        }
        BeanAssertUtil.validate(collectedClientData.getTokenBinding());
    }

    public static void validate(TokenBinding tokenBinding) {
        if (tokenBinding == null) {
            return;
        }
        if (tokenBinding.getStatus() == null) {
            throw new ConstraintViolationException("status must not be null");
        }
    }

    public static void validate(AttestationObject attestationObject) {
        if (attestationObject == null) {
            throw new ConstraintViolationException("attestationObject must not be null");
        }
        if (attestationObject.getAttestationStatement() == null) {
            throw new ConstraintViolationException("attestationStatement must not be null");
        }
        if (attestationObject.getAuthenticatorData() == null) {
            throw new ConstraintViolationException("authenticatorData must not be null");
        }
        BeanAssertUtil.validate(attestationObject.getAttestationStatement());
        BeanAssertUtil.validate(attestationObject.getAuthenticatorData());
    }

    public static <T extends ExtensionAuthenticatorOutput> void validate(AuthenticatorData<T> authenticatorData) {
        byte[] rpIdHash;
        AttestedCredentialData attestedCredentialData = authenticatorData.getAttestedCredentialData();
        if (attestedCredentialData != null) {
            BeanAssertUtil.validate(attestedCredentialData);
        }
        if ((rpIdHash = authenticatorData.getRpIdHash()) == null) {
            throw new ConstraintViolationException("rpIdHash must not be null");
        }
        if (rpIdHash.length != 32) {
            throw new BadRpIdException("rpIdHash must be 32 bytes length");
        }
        long signCount = authenticatorData.getSignCount();
        if (signCount < 0L || signCount > 0xFFFFFFFFL) {
            throw new ConstraintViolationException("signCount must be unsigned int");
        }
        AuthenticationExtensionsAuthenticatorOutputs<T> extensions = authenticatorData.getExtensions();
        BeanAssertUtil.validateAuthenticatorExtensionsOutputs(extensions);
    }

    public static void validate(AttestedCredentialData attestedCredentialData) {
        AAGUID aaguid = attestedCredentialData.getAaguid();
        if (aaguid == null) {
            throw new ConstraintViolationException("aaguid must not be null");
        }
        if (attestedCredentialData.getCredentialId() == null) {
            throw new ConstraintViolationException("credentialId must not be null");
        }
        CredentialPublicKey credentialPublicKey = attestedCredentialData.getCredentialPublicKey();
        if (credentialPublicKey == null) {
            throw new ConstraintViolationException("credentialPublicKey must not be null");
        }
        BeanAssertUtil.validate(credentialPublicKey);
    }

    public static void validateAuthenticationExtensionsClientOutputs(AuthenticationExtensionsClientOutputs<ExtensionClientOutput> authenticationExtensionsClientOutputs) {
        if (authenticationExtensionsClientOutputs == null) {
            return;
        }
        for (Map.Entry set : authenticationExtensionsClientOutputs.entrySet()) {
            BeanAssertUtil.validate((String)set.getKey(), (ExtensionOutput)set.getValue());
        }
    }

    public static <T extends ExtensionAuthenticatorOutput> void validateAuthenticatorExtensionsOutputs(AuthenticationExtensionsAuthenticatorOutputs<T> authenticationExtensionsAuthenticatorOutputs) {
        if (authenticationExtensionsAuthenticatorOutputs == null) {
            return;
        }
        for (Map.Entry set : authenticationExtensionsAuthenticatorOutputs.entrySet()) {
            BeanAssertUtil.validate((String)set.getKey(), (ExtensionOutput)set.getValue());
        }
    }

    public static void validate(String identifier, ExtensionOutput extensionOutput) {
        if (identifier == null) {
            throw new ConstraintViolationException("identifier must not be null");
        }
        if (!identifier.equals(extensionOutput.getIdentifier())) {
            throw new ConstraintViolationException("identifier must match");
        }
        extensionOutput.validate();
    }

    public static void validate(ServerProperty serverProperty) {
        if (serverProperty.getRpId() == null) {
            throw new ConstraintViolationException("rpId must not be null");
        }
        if (serverProperty.getChallenge() == null) {
            throw new ConstraintViolationException("challenge must not be null");
        }
        if (serverProperty.getOrigin() == null) {
            throw new ConstraintViolationException("origin must not be null");
        }
    }

    public static void validate(AttestationStatement attestationStatement) {
        attestationStatement.validate();
    }

    public static void validate(CredentialPublicKey credentialPublicKey) {
        credentialPublicKey.validate();
    }
}

