/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.jackson.WebAuthnCBORModule;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;

public class CborConverter
implements Serializable {
    private static final String INPUT_MISMATCH_ERROR_MESSAGE = "Input data does not match expected form";
    private ObjectMapper jsonMapper;
    private ObjectMapper cborMapper;
    private boolean cborMapperInitialized = false;
    private JsonConverter jsonConverter;

    public CborConverter(ObjectMapper jsonMapper, ObjectMapper cborMapper) {
        AssertUtil.notNull((Object)jsonMapper, (String)"jsonMapper must not be null");
        AssertUtil.notNull((Object)cborMapper, (String)"cborMapper must not be null");
        AssertUtil.isTrue((!(jsonMapper.getFactory() instanceof CBORFactory) ? 1 : 0) != 0, (String)"factory of jsonMapper must be JsonFactory.");
        AssertUtil.isTrue((boolean)(cborMapper.getFactory() instanceof CBORFactory), (String)"factory of cborMapper must be CBORFactory.");
        this.jsonMapper = jsonMapper;
        this.cborMapper = cborMapper;
    }

    public CborConverter() {
        this(new ObjectMapper(), new ObjectMapper((JsonFactory)new CBORFactory()));
    }

    public <T> T readValue(byte[] src, Class valueType) {
        try {
            return (T)this.getCborMapper().readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(InputStream src, Class valueType) {
        try {
            return (T)this.getCborMapper().readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(byte[] src, TypeReference valueTypeRef) {
        try {
            return (T)this.getCborMapper().readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public AuthenticationExtensionsAuthenticatorOutputs readValue(InputStream inputStream, TypeReference<AuthenticationExtensionsAuthenticatorOutputs> typeReference) {
        try {
            return (AuthenticationExtensionsAuthenticatorOutputs)this.getCborMapper().readValue(inputStream, typeReference);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonNode readTree(byte[] bytes) {
        try {
            return this.getCborMapper().readTree(bytes);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] writeValueAsBytes(Object value) {
        try {
            return this.getCborMapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private ObjectMapper getCborMapper() {
        if (!this.cborMapperInitialized) {
            this.cborMapper.registerModule((Module)new WebAuthnCBORModule(this.getJsonConverter(), this));
            this.cborMapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
            this.cborMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.cborMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.cborMapperInitialized = true;
        }
        return this.cborMapper;
    }

    public JsonConverter getJsonConverter() {
        if (this.jsonConverter == null) {
            this.jsonConverter = new JsonConverter(this.jsonMapper, this.cborMapper);
        }
        return this.jsonConverter;
    }
}

