/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest;

import com.webauthn4j.appattest.data.DCAssertion;
import com.webauthn4j.appattest.data.DCAssertionData;
import com.webauthn4j.appattest.data.DCAssertionParameters;
import com.webauthn4j.appattest.data.DCAssertionRequest;
import com.webauthn4j.appattest.validator.DCAssertionDataValidator;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.CustomCoreAuthenticationValidator;
import com.webauthn4j.validator.exception.ValidationException;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DeviceCheckAssertionManager {
    private final AuthenticatorDataConverter authenticatorDataConverter;
    private final DCAssertionDataValidator dcAssertionDataValidator;
    private final CborConverter cborConverter;

    public DeviceCheckAssertionManager(@NonNull List<CustomCoreAuthenticationValidator> customAuthenticationValidators, @NonNull ObjectConverter objectConverter) {
        AssertUtil.notNull(customAuthenticationValidators, (String)"customAuthenticationValidators must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.dcAssertionDataValidator = new DCAssertionDataValidator(customAuthenticationValidators);
        this.authenticatorDataConverter = new AuthenticatorDataConverter(objectConverter);
        this.cborConverter = objectConverter.getCborConverter();
    }

    public DeviceCheckAssertionManager(@NonNull List<CustomCoreAuthenticationValidator> customAuthenticationValidators) {
        this(customAuthenticationValidators, new ObjectConverter());
    }

    public DeviceCheckAssertionManager() {
        this(Collections.emptyList(), new ObjectConverter());
    }

    public @NonNull DCAssertionData parse(@NonNull DCAssertionRequest dcAssertionRequest) throws DataConversionException {
        AssertUtil.notNull((Object)dcAssertionRequest, (String)"dcAssertionRequest must not be null");
        byte[] credentialId = dcAssertionRequest.getKeyId();
        DCAssertion assertion = (DCAssertion)this.cborConverter.readValue(dcAssertionRequest.getAssertion(), DCAssertion.class);
        byte[] authenticatorDataBytes = assertion == null ? null : assertion.getAuthenticatorData();
        AuthenticatorData authenticatorData = authenticatorDataBytes == null ? null : this.authenticatorDataConverter.convert(authenticatorDataBytes);
        byte[] clientDataHash = dcAssertionRequest.getClientDataHash();
        byte[] signature = assertion == null ? null : assertion.getSignature();
        return new DCAssertionData(credentialId, (AuthenticatorData<AuthenticationExtensionAuthenticatorOutput>)authenticatorData, authenticatorDataBytes, clientDataHash, signature);
    }

    public @NonNull DCAssertionData validate(@NonNull DCAssertionRequest dcAssertionRequest, @NonNull DCAssertionParameters dcAssertionParameters) throws DataConversionException, ValidationException {
        DCAssertionData dcAssertionData = this.parse(dcAssertionRequest);
        return this.validate(dcAssertionData, dcAssertionParameters);
    }

    public @NonNull DCAssertionData validate(@NonNull DCAssertionData dcAssertionData, @NonNull DCAssertionParameters dcAssertionParameters) throws ValidationException {
        this.getDCAssertionDataValidator().validate(dcAssertionData, dcAssertionParameters);
        return dcAssertionData;
    }

    public @NonNull DCAssertionDataValidator getDCAssertionDataValidator() {
        return this.dcAssertionDataValidator;
    }
}

