/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.appattest.DeviceCheckAssertionManager;
import com.webauthn4j.appattest.DeviceCheckAttestationManager;
import com.webauthn4j.appattest.converter.jackson.DeviceCheckCBORModule;
import com.webauthn4j.appattest.data.DCAssertionData;
import com.webauthn4j.appattest.data.DCAssertionParameters;
import com.webauthn4j.appattest.data.DCAssertionRequest;
import com.webauthn4j.appattest.data.DCAttestationData;
import com.webauthn4j.appattest.data.DCAttestationParameters;
import com.webauthn4j.appattest.data.DCAttestationRequest;
import com.webauthn4j.appattest.validator.DCAssertionDataValidator;
import com.webauthn4j.appattest.validator.DCAttestationDataValidator;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.validator.CustomCoreAuthenticationValidator;
import com.webauthn4j.validator.CustomCoreRegistrationValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.NullCertPathTrustworthinessValidator;
import com.webauthn4j.validator.exception.ValidationException;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DeviceCheckManager {
    private final DeviceCheckAttestationManager deviceCheckAttestationManager;
    private final DeviceCheckAssertionManager deviceCheckAssertionManager;

    public DeviceCheckManager(@NonNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NonNull List<CustomCoreRegistrationValidator> customRegistrationValidators, @NonNull List<CustomCoreAuthenticationValidator> customAuthenticationValidators, @NonNull ObjectConverter objectConverter) {
        this.deviceCheckAttestationManager = new DeviceCheckAttestationManager(certPathTrustworthinessValidator, customRegistrationValidators, objectConverter);
        this.deviceCheckAssertionManager = new DeviceCheckAssertionManager(customAuthenticationValidators, objectConverter);
    }

    public DeviceCheckManager(@NonNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NonNull List<CustomCoreRegistrationValidator> customRegistrationValidators, @NonNull List<CustomCoreAuthenticationValidator> customAuthenticationValidators) {
        this(certPathTrustworthinessValidator, customRegistrationValidators, customAuthenticationValidators, DeviceCheckManager.createObjectConverter());
    }

    public DeviceCheckManager(@NonNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NonNull ObjectConverter objectConverter) {
        this(certPathTrustworthinessValidator, new ArrayList<CustomCoreRegistrationValidator>(), new ArrayList<CustomCoreAuthenticationValidator>(), objectConverter);
    }

    public DeviceCheckManager(@NonNull CertPathTrustworthinessValidator certPathTrustworthinessValidator) {
        this(certPathTrustworthinessValidator, new ArrayList<CustomCoreRegistrationValidator>(), new ArrayList<CustomCoreAuthenticationValidator>());
    }

    public static @NonNull DeviceCheckManager createNonStrictDeviceCheckManager() {
        ObjectMapper jsonMapper = new ObjectMapper();
        ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
        cborMapper.registerModule((Module)new DeviceCheckCBORModule());
        ObjectConverter objectConverter = new ObjectConverter(jsonMapper, cborMapper);
        return DeviceCheckManager.createNonStrictDeviceCheckManager(objectConverter);
    }

    public static @NonNull DeviceCheckManager createNonStrictDeviceCheckManager(@NonNull ObjectConverter objectConverter) {
        return new DeviceCheckManager((CertPathTrustworthinessValidator)new NullCertPathTrustworthinessValidator(), objectConverter);
    }

    public static @NonNull ObjectConverter createObjectConverter() {
        ObjectMapper jsonMapper = new ObjectMapper();
        ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
        cborMapper.registerModule((Module)new DeviceCheckCBORModule());
        return new ObjectConverter(jsonMapper, cborMapper);
    }

    public @NonNull DCAttestationData parse(@NonNull DCAttestationRequest dcAttestationRequest) throws DataConversionException {
        return this.deviceCheckAttestationManager.parse(dcAttestationRequest);
    }

    public @NonNull DCAttestationData validate(@NonNull DCAttestationRequest dcAttestationRequest, @NonNull DCAttestationParameters dcAttestationParameters) throws DataConversionException, ValidationException {
        return this.deviceCheckAttestationManager.validate(dcAttestationRequest, dcAttestationParameters);
    }

    public @NonNull DCAttestationData validate(@NonNull DCAttestationData dcAttestationData, @NonNull DCAttestationParameters dcAttestationParameters) throws ValidationException {
        return this.deviceCheckAttestationManager.validate(dcAttestationData, dcAttestationParameters);
    }

    public @NonNull DCAssertionData parse(@NonNull DCAssertionRequest dcAssertionRequest) throws DataConversionException {
        return this.deviceCheckAssertionManager.parse(dcAssertionRequest);
    }

    public @NonNull DCAssertionData validate(@NonNull DCAssertionRequest dcAssertionRequest, @NonNull DCAssertionParameters dcAssertionParameters) throws DataConversionException, ValidationException {
        return this.deviceCheckAssertionManager.validate(dcAssertionRequest, dcAssertionParameters);
    }

    public @NonNull DCAssertionData validate(@NonNull DCAssertionData dcAssertionData, @NonNull DCAssertionParameters dcAssertionParameters) throws ValidationException {
        return this.deviceCheckAssertionManager.validate(dcAssertionData, dcAssertionParameters);
    }

    public @NonNull DCAttestationDataValidator getAttestationDataValidator() {
        return this.deviceCheckAttestationManager.getDCAttestationDataValidator();
    }

    public @NonNull DCAssertionDataValidator getAssertionDataValidator() {
        return this.deviceCheckAssertionManager.getDCAssertionDataValidator();
    }
}

