/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest.data;

import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DCAttestationRequest {
    private final byte[] keyId;
    private final byte[] attestationObject;
    private final byte[] clientDataHash;

    public DCAttestationRequest(@Nullable byte[] keyId, @Nullable byte[] attestationObject, @Nullable byte[] clientDataHash) {
        this.keyId = ArrayUtil.clone((byte[])keyId);
        this.attestationObject = ArrayUtil.clone((byte[])attestationObject);
        this.clientDataHash = ArrayUtil.clone((byte[])clientDataHash);
    }

    public @Nullable byte[] getKeyId() {
        return ArrayUtil.clone((byte[])this.keyId);
    }

    public @Nullable byte[] getAttestationObject() {
        return ArrayUtil.clone((byte[])this.attestationObject);
    }

    public @Nullable byte[] getClientDataHash() {
        return ArrayUtil.clone((byte[])this.clientDataHash);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DCAttestationRequest that = (DCAttestationRequest)o;
        return Arrays.equals(this.keyId, that.keyId) && Arrays.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.clientDataHash, that.clientDataHash);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.keyId);
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        return result;
    }
}

