/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="apple-appattest")
public class AppleAppAttestAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "apple-appattest";
    @JsonProperty
    private final AttestationCertificatePath x5c;
    @JsonProperty
    private final byte[] receipt;

    public AppleAppAttestAttestationStatement(@JsonProperty(value="x5c") @NonNull AttestationCertificatePath x5c, @JsonProperty(value="receipt") @NonNull byte[] receipt) {
        AssertUtil.notNull((Object)x5c, (String)"x5c must not be null");
        AssertUtil.notNull((Object)receipt, (String)"receipt must not be null");
        this.x5c = x5c;
        this.receipt = receipt;
    }

    @JsonCreator
    private static AppleAppAttestAttestationStatement deserialize(@JsonProperty(value="x5c") @NonNull AttestationCertificatePath x5c, @JsonProperty(value="receipt") @NonNull byte[] receipt) throws MismatchedInputException {
        try {
            return new AppleAppAttestAttestationStatement(x5c, receipt);
        }
        catch (IllegalArgumentException e) {
            throw MismatchedInputException.from(null, AppleAppAttestAttestationStatement.class, (String)"failed to parse");
        }
    }

    public @NonNull byte[] getReceipt() {
        return ArrayUtil.clone((byte[])this.receipt);
    }

    public @NonNull AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    public @NonNull String getFormat() {
        return FORMAT;
    }

    public void validate() {
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppleAppAttestAttestationStatement that = (AppleAppAttestAttestationStatement)o;
        return Objects.equals(this.x5c, that.x5c) && Arrays.equals(this.receipt, that.receipt);
    }

    public int hashCode() {
        int result = Objects.hash(this.x5c);
        result = 31 * result + Arrays.hashCode(this.receipt);
        return result;
    }
}

