/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest.validator;

import com.webauthn4j.appattest.authenticator.DCAppleDeviceImpl;
import com.webauthn4j.appattest.validator.DCAssertionSignatureValidator;
import com.webauthn4j.appattest.validator.DCAuthenticationObject;
import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.CoreAuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AssertionSignatureValidator;
import com.webauthn4j.validator.CoreAuthenticationDataValidator;
import com.webauthn4j.validator.CoreAuthenticationObject;
import com.webauthn4j.validator.CustomCoreAuthenticationValidator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DCAssertionDataValidator
extends CoreAuthenticationDataValidator {
    public DCAssertionDataValidator(List<CustomCoreAuthenticationValidator> customAuthenticationValidators) {
        super(customAuthenticationValidators, (AssertionSignatureValidator)new DCAssertionSignatureValidator());
    }

    protected @NonNull CoreAuthenticationObject createCoreAuthenticationObject(@NonNull CoreAuthenticationData authenticationData, @NonNull CoreAuthenticationParameters authenticationParameters) {
        AssertUtil.notNull((Object)authenticationData, (String)"authenticationData must not be null");
        AssertUtil.notNull((Object)authenticationData, (String)"authenticationParameters must not be null");
        byte[] credentialId = authenticationData.getCredentialId();
        AuthenticatorData authenticatorData = authenticationData.getAuthenticatorData();
        byte[] authenticatorDataBytes = authenticationData.getAuthenticatorDataBytes();
        byte[] clientDataHash = authenticationData.getClientDataHash();
        CoreServerProperty serverProperty = authenticationParameters.getServerProperty();
        CoreAuthenticator authenticator = authenticationParameters.getAuthenticator();
        DCAppleDeviceImpl dcAppleDevice = new DCAppleDeviceImpl(authenticator.getAttestedCredentialData(), authenticator.getAttestationStatement(), authenticator.getCounter(), (AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput>)authenticator.getAuthenticatorExtensions());
        return new DCAuthenticationObject(credentialId, (AuthenticatorData<AuthenticationExtensionAuthenticatorOutput>)authenticatorData, authenticatorDataBytes, clientDataHash, serverProperty, dcAppleDevice);
    }
}

