/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest.validator;

import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.AssertionSignatureValidator;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DCAssertionSignatureValidator
extends AssertionSignatureValidator {
    protected @NonNull byte[] getSignedData(@NonNull CoreAuthenticationData authenticationData) {
        byte[] rawAuthenticatorData = authenticationData.getAuthenticatorDataBytes();
        byte[] clientDataHash = authenticationData.getClientDataHash();
        byte[] concatenated = ByteBuffer.allocate(rawAuthenticatorData.length + clientDataHash.length).put(rawAuthenticatorData).put(clientDataHash).array();
        return MessageDigestUtil.createSHA256().digest(concatenated);
    }
}

