/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest.validator;

import com.webauthn4j.appattest.data.DCAttestationData;
import com.webauthn4j.appattest.validator.DCRegistrationObject;
import com.webauthn4j.appattest.validator.attestation.statement.appleappattest.AppleAppAttestAttestationStatementValidator;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.CoreRegistrationData;
import com.webauthn4j.data.CoreRegistrationParameters;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.CoreRegistrationDataValidator;
import com.webauthn4j.validator.CoreRegistrationObject;
import com.webauthn4j.validator.CustomCoreRegistrationValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.DefaultSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.BadAaguidException;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import com.webauthn4j.validator.exception.MaliciousCounterValueException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DCAttestationDataValidator
extends CoreRegistrationDataValidator {
    private static final AAGUID APPLE_APP_ATTEST_ENVIRONMENT_DEVELOPMENT = new AAGUID("appattestdevelop".getBytes());
    private static final AAGUID APPLE_APP_ATTEST_ENVIRONMENT_PRODUCTION = new AAGUID("appattest\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes());
    private boolean production = true;

    public DCAttestationDataValidator(@NonNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NonNull List<CustomCoreRegistrationValidator> customRegistrationValidatorList, @NonNull ObjectConverter objectConverter) {
        super(Collections.singletonList(new AppleAppAttestAttestationStatementValidator()), certPathTrustworthinessValidator, DCAttestationDataValidator.createSelfAttestationTrustWorthinessValidator(), customRegistrationValidatorList, objectConverter);
    }

    private static @NonNull SelfAttestationTrustworthinessValidator createSelfAttestationTrustWorthinessValidator() {
        DefaultSelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator = new DefaultSelfAttestationTrustworthinessValidator();
        selfAttestationTrustworthinessValidator.setSelfAttestationAllowed(false);
        return selfAttestationTrustworthinessValidator;
    }

    public void validate(@NonNull CoreRegistrationData registrationData, @NonNull CoreRegistrationParameters registrationParameters) {
        super.validate(registrationData, registrationParameters);
        this.validateAuthenticatorData((AuthenticatorData<RegistrationExtensionAuthenticatorOutput>)registrationData.getAttestationObject().getAuthenticatorData());
        this.validateKeyId(registrationData);
    }

    private void validateKeyId(@NonNull CoreRegistrationData registrationData) {
        byte[] credentialId;
        DCAttestationData dcAttestationData = (DCAttestationData)registrationData;
        byte[] keyId = dcAttestationData.getKeyId();
        if (!Arrays.equals(keyId, credentialId = registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCredentialId())) {
            throw new BadAttestationStatementException("key identifier doesn't match credentialId.");
        }
    }

    protected @NonNull CoreRegistrationObject createCoreRegistrationObject(@NonNull CoreRegistrationData registrationData, @NonNull CoreRegistrationParameters registrationParameters) {
        AssertUtil.notNull((Object)registrationData, (String)"authenticationData must not be null");
        AssertUtil.notNull((Object)registrationData, (String)"authenticationParameters must not be null");
        DCAttestationData dcAttestationData = (DCAttestationData)registrationData;
        return new DCRegistrationObject(dcAttestationData.getKeyId(), registrationData.getAttestationObject(), registrationData.getAttestationObjectBytes(), registrationData.getClientDataHash(), registrationParameters.getServerProperty(), Instant.now());
    }

    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    private void validateAuthenticatorData(@NonNull AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData) {
        AAGUID expectedAAGUID;
        if (authenticatorData.getSignCount() != 0L) {
            throw new MaliciousCounterValueException("Counter is not zero");
        }
        AAGUID aaguid = authenticatorData.getAttestedCredentialData().getAaguid();
        AAGUID aAGUID = expectedAAGUID = this.isProduction() ? APPLE_APP_ATTEST_ENVIRONMENT_PRODUCTION : APPLE_APP_ATTEST_ENVIRONMENT_DEVELOPMENT;
        if (!aaguid.equals((Object)expectedAAGUID)) {
            throw new BadAaguidException("Expected AAGUID of either 'appattestdevelop' or 'appattest'");
        }
    }
}

