/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest.validator.attestation.statement.appleappattest;

import com.webauthn4j.appattest.data.attestation.statement.AppleAppAttestAttestationStatement;
import com.webauthn4j.appattest.validator.DCRegistrationObject;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.ECUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.CoreRegistrationObject;
import com.webauthn4j.validator.attestation.statement.AbstractStatementValidator;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.kerby.asn1.type.Asn1OctetString;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AppleAppAttestAttestationStatementValidator
extends AbstractStatementValidator<AppleAppAttestAttestationStatement> {
    public static final String APPLE_CRED_CERT_EXTENSION_OID = "1.2.840.113635.100.8.2";

    public AttestationType validate(@NonNull CoreRegistrationObject registrationObject) {
        AssertUtil.notNull((Object)registrationObject, (String)"registrationObject must not be null");
        if (!(registrationObject instanceof DCRegistrationObject)) {
            throw new IllegalArgumentException("registrationObject must be an instance of DCRegistrationObject.");
        }
        if (!this.supports(registrationObject)) {
            throw new IllegalArgumentException(String.format("Specified format '%s' is not supported by %s.", registrationObject.getAttestationObject().getFormat(), ((Object)((Object)this)).getClass().getName()));
        }
        AppleAppAttestAttestationStatement attestationStatement = (AppleAppAttestAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        this.validateAttestationStatementNotNull(attestationStatement);
        this.validateX5c(attestationStatement);
        this.validateNonce(registrationObject);
        this.validatePublicKey(registrationObject);
        return AttestationType.BASIC;
    }

    void validateAttestationStatementNotNull(@Nullable AppleAppAttestAttestationStatement attestationStatement) {
        if (attestationStatement == null) {
            throw new BadAttestationStatementException("attestation statement is not found.");
        }
    }

    void validateX5c(@NonNull AppleAppAttestAttestationStatement attestationStatement) {
        if (attestationStatement.getX5c().isEmpty()) {
            throw new BadAttestationStatementException("No attestation certificate is found in Apple App Attest attestation statement.");
        }
    }

    public boolean supports(CoreRegistrationObject registrationObject) {
        return super.supports(registrationObject) && registrationObject instanceof DCRegistrationObject;
    }

    private void validateNonce(CoreRegistrationObject registrationObject) {
        AppleAppAttestAttestationStatement attestationStatement = this.getAttestationStatement(registrationObject);
        X509Certificate attestationCertificate = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate();
        byte[] actualNonce = this.extractNonce(attestationCertificate);
        byte[] clientDataHash = registrationObject.getClientDataHash();
        byte[] authenticatorData = registrationObject.getAuthenticatorDataBytes();
        byte[] composite = ByteBuffer.allocate(authenticatorData.length + clientDataHash.length).put(authenticatorData).put(clientDataHash).array();
        byte[] expectedNonce = MessageDigestUtil.createSHA256().digest(composite);
        if (!Arrays.equals(actualNonce, expectedNonce)) {
            throw new BadAttestationStatementException("App Attest nonce doesn't match.");
        }
    }

    private void validatePublicKey(CoreRegistrationObject registrationObject) {
        byte[] publicKey = ECUtil.createUncompressedPublicKey((ECPublicKey)((ECPublicKey)this.getAttestationStatement(registrationObject).getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey()));
        DCRegistrationObject dcRegistrationObject = (DCRegistrationObject)registrationObject;
        byte[] keyId = dcRegistrationObject.getKeyId();
        if (!Arrays.equals(MessageDigestUtil.createSHA256().digest(publicKey), keyId)) {
            throw new BadAttestationStatementException("key identifier doesn't match SHA-256 of the publickey");
        }
    }

    private AppleAppAttestAttestationStatement getAttestationStatement(CoreRegistrationObject registrationObject) {
        return (AppleAppAttestAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
    }

    byte[] extractNonce(X509Certificate attestationCertificate) {
        byte[] attestationExtensionBytes = attestationCertificate.getExtensionValue(APPLE_CRED_CERT_EXTENSION_OID);
        if (attestationExtensionBytes == null) {
            throw new BadAttestationStatementException("Apple X.509 extension not found");
        }
        Asn1OctetString envelope = new Asn1OctetString();
        try {
            envelope.decode(attestationExtensionBytes);
            Asn1Container container = (Asn1Container)Asn1Parser.parse((ByteBuffer)ByteBuffer.wrap((byte[])envelope.getValue()));
            Asn1OctetString subEnvelop = new Asn1OctetString();
            subEnvelop.decode((Asn1ParseResult)container.getChildren().get(0));
            return (byte[])subEnvelop.getValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

