/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest;

import com.webauthn4j.appattest.data.DCAttestationData;
import com.webauthn4j.appattest.data.DCAttestationParameters;
import com.webauthn4j.appattest.data.DCAttestationRequest;
import com.webauthn4j.appattest.validator.DCAttestationDataValidator;
import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.CustomCoreRegistrationValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.exception.ValidationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeviceCheckAttestationManager {
    private final AttestationObjectConverter attestationObjectConverter;
    private final DCAttestationDataValidator dcAttestationDataValidator;

    public DeviceCheckAttestationManager(@NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull List<CustomCoreRegistrationValidator> customRegistrationValidators, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)certPathTrustworthinessValidator, (String)"certPathTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.dcAttestationDataValidator = new DCAttestationDataValidator(certPathTrustworthinessValidator, customRegistrationValidators, objectConverter);
        this.attestationObjectConverter = new AttestationObjectConverter(objectConverter);
    }

    @NotNull
    public DCAttestationData parse(@NotNull DCAttestationRequest dcAttestationRequest) throws DataConversionException {
        AssertUtil.notNull((Object)dcAttestationRequest, (String)"dcAttestationRequest must not be null");
        byte[] keyId = dcAttestationRequest.getKeyId();
        byte[] attestationObjectBytes = dcAttestationRequest.getAttestationObject();
        byte[] clientDataHash = dcAttestationRequest.getClientDataHash();
        AttestationObject attestationObject = attestationObjectBytes == null ? null : this.attestationObjectConverter.convert(attestationObjectBytes);
        return new DCAttestationData(keyId, attestationObject, attestationObjectBytes, clientDataHash);
    }

    @NotNull
    public DCAttestationData validate(@NotNull DCAttestationRequest dcAttestationRequest, @NotNull DCAttestationParameters dcAttestationParameters) throws DataConversionException, ValidationException {
        DCAttestationData dcAttestationData = this.parse(dcAttestationRequest);
        return this.validate(dcAttestationData, dcAttestationParameters);
    }

    @NotNull
    public DCAttestationData validate(@NotNull DCAttestationData dcAttestationData, @NotNull DCAttestationParameters dcAttestationParameters) throws ValidationException {
        this.getDCAttestationDataValidator().validate(dcAttestationData, dcAttestationParameters);
        return dcAttestationData;
    }

    @NotNull
    public DCAttestationDataValidator getDCAttestationDataValidator() {
        return this.dcAttestationDataValidator;
    }
}

