/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.appattest.DeviceCheckAssertionManager;
import com.webauthn4j.appattest.DeviceCheckAttestationManager;
import com.webauthn4j.appattest.converter.jackson.DeviceCheckCBORModule;
import com.webauthn4j.appattest.data.DCAssertionData;
import com.webauthn4j.appattest.data.DCAssertionParameters;
import com.webauthn4j.appattest.data.DCAssertionRequest;
import com.webauthn4j.appattest.data.DCAttestationData;
import com.webauthn4j.appattest.data.DCAttestationParameters;
import com.webauthn4j.appattest.data.DCAttestationRequest;
import com.webauthn4j.appattest.validator.DCAssertionDataValidator;
import com.webauthn4j.appattest.validator.DCAttestationDataValidator;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.validator.CustomCoreAuthenticationValidator;
import com.webauthn4j.validator.CustomCoreRegistrationValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.NullCertPathTrustworthinessValidator;
import com.webauthn4j.validator.exception.ValidationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeviceCheckManager {
    private final DeviceCheckAttestationManager deviceCheckAttestationManager;
    private final DeviceCheckAssertionManager deviceCheckAssertionManager;

    public DeviceCheckManager(@NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull List<CustomCoreRegistrationValidator> customRegistrationValidators, @NotNull List<CustomCoreAuthenticationValidator> customAuthenticationValidators, @NotNull ObjectConverter objectConverter) {
        this.deviceCheckAttestationManager = new DeviceCheckAttestationManager(certPathTrustworthinessValidator, customRegistrationValidators, objectConverter);
        this.deviceCheckAssertionManager = new DeviceCheckAssertionManager(customAuthenticationValidators, objectConverter);
    }

    public DeviceCheckManager(@NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull List<CustomCoreRegistrationValidator> customRegistrationValidators, @NotNull List<CustomCoreAuthenticationValidator> customAuthenticationValidators) {
        this(certPathTrustworthinessValidator, customRegistrationValidators, customAuthenticationValidators, DeviceCheckManager.createObjectConverter());
    }

    public DeviceCheckManager(@NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull ObjectConverter objectConverter) {
        this(certPathTrustworthinessValidator, new ArrayList<CustomCoreRegistrationValidator>(), new ArrayList<CustomCoreAuthenticationValidator>(), objectConverter);
    }

    public DeviceCheckManager(@NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator) {
        this(certPathTrustworthinessValidator, new ArrayList<CustomCoreRegistrationValidator>(), new ArrayList<CustomCoreAuthenticationValidator>());
    }

    @NotNull
    public static DeviceCheckManager createNonStrictDeviceCheckManager() {
        ObjectMapper jsonMapper = new ObjectMapper();
        ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
        cborMapper.registerModule((Module)new DeviceCheckCBORModule());
        ObjectConverter objectConverter = new ObjectConverter(jsonMapper, cborMapper);
        return DeviceCheckManager.createNonStrictDeviceCheckManager(objectConverter);
    }

    @NotNull
    public static DeviceCheckManager createNonStrictDeviceCheckManager(@NotNull ObjectConverter objectConverter) {
        return new DeviceCheckManager((CertPathTrustworthinessValidator)new NullCertPathTrustworthinessValidator(), objectConverter);
    }

    @NotNull
    public static ObjectConverter createObjectConverter() {
        ObjectMapper jsonMapper = new ObjectMapper();
        ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
        cborMapper.registerModule((Module)new DeviceCheckCBORModule());
        return new ObjectConverter(jsonMapper, cborMapper);
    }

    @NotNull
    public DCAttestationData parse(@NotNull DCAttestationRequest dcAttestationRequest) throws DataConversionException {
        return this.deviceCheckAttestationManager.parse(dcAttestationRequest);
    }

    @NotNull
    public DCAttestationData validate(@NotNull DCAttestationRequest dcAttestationRequest, @NotNull DCAttestationParameters dcAttestationParameters) throws DataConversionException, ValidationException {
        return this.deviceCheckAttestationManager.validate(dcAttestationRequest, dcAttestationParameters);
    }

    @NotNull
    public DCAttestationData validate(@NotNull DCAttestationData dcAttestationData, @NotNull DCAttestationParameters dcAttestationParameters) throws ValidationException {
        return this.deviceCheckAttestationManager.validate(dcAttestationData, dcAttestationParameters);
    }

    @NotNull
    public DCAssertionData parse(@NotNull DCAssertionRequest dcAssertionRequest) throws DataConversionException {
        return this.deviceCheckAssertionManager.parse(dcAssertionRequest);
    }

    @NotNull
    public DCAssertionData validate(@NotNull DCAssertionRequest dcAssertionRequest, @NotNull DCAssertionParameters dcAssertionParameters) throws DataConversionException, ValidationException {
        return this.deviceCheckAssertionManager.validate(dcAssertionRequest, dcAssertionParameters);
    }

    @NotNull
    public DCAssertionData validate(@NotNull DCAssertionData dcAssertionData, @NotNull DCAssertionParameters dcAssertionParameters) throws ValidationException {
        return this.deviceCheckAssertionManager.validate(dcAssertionData, dcAssertionParameters);
    }

    @NotNull
    public DCAttestationDataValidator getAttestationDataValidator() {
        return this.deviceCheckAttestationManager.getDCAttestationDataValidator();
    }

    @NotNull
    public DCAssertionDataValidator getAssertionDataValidator() {
        return this.deviceCheckAssertionManager.getDCAssertionDataValidator();
    }
}

