/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.metadata.CachingMetadataBLOBProvider;
import com.webauthn4j.metadata.HttpClient;
import com.webauthn4j.metadata.SimpleHttpClient;
import com.webauthn4j.metadata.data.MetadataBLOB;
import com.webauthn4j.metadata.data.MetadataBLOBFactory;
import com.webauthn4j.metadata.exception.MDSException;
import com.webauthn4j.util.CertificateUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FidoMDS3MetadataBLOBProvider
extends CachingMetadataBLOBProvider {
    private static final String DEFAULT_BLOB_ENDPOINT = "https://mds.fidoalliance.org/";
    private final MetadataBLOBFactory metadataBLOBFactory;
    private final String blobEndpoint;
    private final HttpClient httpClient;
    private final Set<TrustAnchor> trustAnchors;
    private boolean revocationCheckEnabled = true;

    public FidoMDS3MetadataBLOBProvider(@NonNull ObjectConverter objectConverter, @NonNull String blobEndpoint, @NonNull HttpClient httpClient, @NonNull Set<TrustAnchor> trustAnchors) {
        this.metadataBLOBFactory = new MetadataBLOBFactory(objectConverter);
        this.blobEndpoint = blobEndpoint;
        this.httpClient = httpClient;
        this.trustAnchors = trustAnchors;
    }

    public FidoMDS3MetadataBLOBProvider(@NonNull ObjectConverter objectConverter, @NonNull String blobEndpoint, @NonNull Set<TrustAnchor> trustAnchors) {
        this(objectConverter, blobEndpoint, new SimpleHttpClient(), trustAnchors);
    }

    public FidoMDS3MetadataBLOBProvider(@NonNull ObjectConverter objectConverter, @NonNull String blobEndpoint, @NonNull X509Certificate trustAnchorCertificate) {
        this(objectConverter, blobEndpoint, new SimpleHttpClient(), Collections.singleton(new TrustAnchor(trustAnchorCertificate, null)));
    }

    public FidoMDS3MetadataBLOBProvider(@NonNull ObjectConverter objectConverter, @NonNull Set<TrustAnchor> trustAnchors) {
        this(objectConverter, DEFAULT_BLOB_ENDPOINT, trustAnchors);
    }

    public FidoMDS3MetadataBLOBProvider(@NonNull ObjectConverter objectConverter, @NonNull X509Certificate trustAnchorCertificate) {
        this(objectConverter, DEFAULT_BLOB_ENDPOINT, Collections.singleton(new TrustAnchor(trustAnchorCertificate, null)));
    }

    @Override
    protected @NonNull MetadataBLOB doProvide() {
        String responseBody = this.httpClient.fetch(this.blobEndpoint);
        MetadataBLOB metadataBLOB = this.metadataBLOBFactory.parse(responseBody);
        if (!metadataBLOB.isValidSignature()) {
            throw new MDSException("MetadataBLOB signature is invalid");
        }
        this.validateCertPath(metadataBLOB);
        return metadataBLOB;
    }

    private void validateCertPath(@NonNull MetadataBLOB metadataBLOB) {
        CertPath certPath = metadataBLOB.getHeader().getX5c();
        CertPathValidator certPathValidator = CertificateUtil.createCertPathValidator();
        PKIXParameters certPathParameters = CertificateUtil.createPKIXParameters(this.trustAnchors);
        certPathParameters.setRevocationEnabled(this.revocationCheckEnabled);
        if (this.revocationCheckEnabled) {
            PKIXRevocationChecker pkixRevocationChecker = (PKIXRevocationChecker)certPathValidator.getRevocationChecker();
            pkixRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS));
            certPathParameters.addCertPathChecker(pkixRevocationChecker);
        }
        try {
            certPathValidator.validate(certPath, certPathParameters);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MDSException("invalid algorithm parameter", e);
        }
        catch (CertPathValidatorException e) {
            throw new MDSException("invalid cert path", e);
        }
    }

    public boolean isRevocationCheckEnabled() {
        return this.revocationCheckEnabled;
    }

    public void setRevocationCheckEnabled(boolean revocationCheckEnabled) {
        this.revocationCheckEnabled = revocationCheckEnabled;
    }
}

