/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.data.AuthenticatorAttestationType;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.MetadataBLOBProvider;
import com.webauthn4j.metadata.MetadataStatementRepository;
import com.webauthn4j.metadata.data.MetadataBLOBPayloadEntry;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import com.webauthn4j.metadata.data.toc.StatusReport;
import com.webauthn4j.util.HexUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MetadataBLOBBasedMetadataStatementRepository
implements MetadataStatementRepository {
    private final List<MetadataBLOBProvider> metadataBLOBProviders;
    private boolean notFidoCertifiedAllowed = false;
    private boolean selfAssertionSubmittedAllowed = false;

    public MetadataBLOBBasedMetadataStatementRepository(MetadataBLOBProvider ... metadataBLOBProviders) {
        this.metadataBLOBProviders = Arrays.asList(metadataBLOBProviders);
    }

    @Override
    public Set<MetadataStatement> find(AAGUID aaguid) {
        return this.metadataBLOBProviders.stream().flatMap(provider -> provider.provide().getPayload().getEntries().stream()).filter(entry -> Objects.equals(entry.getAaguid(), aaguid)).filter(this::checkMetadataBLOBPayloadEntry).map(MetadataBLOBPayloadEntry::getMetadataStatement).filter(this::checkSurrogateMetadataStatementAttestationRootCertificate).collect(Collectors.toSet());
    }

    @Override
    public Set<MetadataStatement> find(byte[] attestationCertificateKeyIdentifier) {
        return this.metadataBLOBProviders.stream().flatMap(provider -> provider.provide().getPayload().getEntries().stream()).filter(entry -> {
            MetadataStatement metadataStatement = entry.getMetadataStatement();
            if (metadataStatement == null || metadataStatement.getAttestationCertificateKeyIdentifiers() == null) {
                return false;
            }
            return metadataStatement.getAttestationCertificateKeyIdentifiers().stream().anyMatch(identifier -> Arrays.equals(HexUtil.decode((String)identifier), attestationCertificateKeyIdentifier));
        }).map(MetadataBLOBPayloadEntry::getMetadataStatement).filter(this::checkSurrogateMetadataStatementAttestationRootCertificate).collect(Collectors.toSet());
    }

    public boolean isNotFidoCertifiedAllowed() {
        return this.notFidoCertifiedAllowed;
    }

    public void setNotFidoCertifiedAllowed(boolean notFidoCertifiedAllowed) {
        this.notFidoCertifiedAllowed = notFidoCertifiedAllowed;
    }

    public boolean isSelfAssertionSubmittedAllowed() {
        return this.selfAssertionSubmittedAllowed;
    }

    public void setSelfAssertionSubmittedAllowed(boolean selfAssertionSubmittedAllowed) {
        this.selfAssertionSubmittedAllowed = selfAssertionSubmittedAllowed;
    }

    private boolean checkMetadataBLOBPayloadEntry(@NotNull MetadataBLOBPayloadEntry metadataBLOBPayloadEntry) {
        List<StatusReport> statusReports = metadataBLOBPayloadEntry.getStatusReports();
        for (StatusReport report : statusReports) {
            switch (report.getStatus()) {
                case UPDATE_AVAILABLE: {
                    break;
                }
                case FIDO_CERTIFIED: 
                case FIDO_CERTIFIED_L1: 
                case FIDO_CERTIFIED_L1_PLUS: 
                case FIDO_CERTIFIED_L2: 
                case FIDO_CERTIFIED_L2_PLUS: 
                case FIDO_CERTIFIED_L3: 
                case FIDO_CERTIFIED_L3_PLUS: {
                    break;
                }
                case NOT_FIDO_CERTIFIED: {
                    if (this.notFidoCertifiedAllowed) break;
                    return false;
                }
                case SELF_ASSERTION_SUBMITTED: {
                    if (this.selfAssertionSubmittedAllowed) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkSurrogateMetadataStatementAttestationRootCertificate(MetadataStatement metadataStatement) {
        boolean isSurrogate;
        boolean bl = isSurrogate = metadataStatement != null && metadataStatement.getAttestationTypes().stream().allMatch(type -> type.equals((Object)AuthenticatorAttestationType.BASIC_SURROGATE));
        if (isSurrogate) {
            return metadataStatement.getAttestationRootCertificates().isEmpty();
        }
        return true;
    }
}

