/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.toc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.webauthn4j.metadata.data.toc.AuthenticatorStatus;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusReport {
    @JsonProperty
    @NotNull
    private final AuthenticatorStatus status;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @JsonSerialize(using=LocalDateSerializer.class)
    @JsonProperty
    @Nullable
    private final LocalDate effectiveDate;
    @JsonProperty
    @Nullable
    private final X509Certificate certificate;
    @JsonProperty
    @Nullable
    private final String url;
    @JsonProperty
    @Nullable
    private final String certificationDescriptor;
    @JsonProperty
    @Nullable
    private final String certificateNumber;
    @JsonProperty
    @Nullable
    private final String certificationPolicyVersion;
    @JsonProperty
    @Nullable
    private final String certificationRequirementsVersion;

    @JsonCreator
    public StatusReport(@JsonProperty(value="status") @NotNull AuthenticatorStatus status, @JsonProperty(value="effectiveDate") @Nullable LocalDate effectiveDate, @JsonProperty(value="certificate") @Nullable X509Certificate certificate, @JsonProperty(value="url") @Nullable String url, @JsonProperty(value="certificationDescriptor") @Nullable String certificationDescriptor, @JsonProperty(value="certificateNumber") @Nullable String certificateNumber, @JsonProperty(value="certificationPolicyVersion") @Nullable String certificationPolicyVersion, @JsonProperty(value="certificationRequirementsVersion") @Nullable String certificationRequirementsVersion) {
        this.status = status;
        this.effectiveDate = effectiveDate;
        this.certificate = certificate;
        this.url = url;
        this.certificationDescriptor = certificationDescriptor;
        this.certificateNumber = certificateNumber;
        this.certificationPolicyVersion = certificationPolicyVersion;
        this.certificationRequirementsVersion = certificationRequirementsVersion;
    }

    @NotNull
    public AuthenticatorStatus getStatus() {
        return this.status;
    }

    @Nullable
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Nullable
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getCertificationDescriptor() {
        return this.certificationDescriptor;
    }

    @Nullable
    public String getCertificateNumber() {
        return this.certificateNumber;
    }

    @Nullable
    public String getCertificationPolicyVersion() {
        return this.certificationPolicyVersion;
    }

    @Nullable
    public String getCertificationRequirementsVersion() {
        return this.certificationRequirementsVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusReport that = (StatusReport)o;
        return this.status == that.status && Objects.equals(this.effectiveDate, that.effectiveDate) && Objects.equals(this.certificate, that.certificate) && Objects.equals(this.url, that.url) && Objects.equals(this.certificationDescriptor, that.certificationDescriptor) && Objects.equals(this.certificateNumber, that.certificateNumber) && Objects.equals(this.certificationPolicyVersion, that.certificationPolicyVersion) && Objects.equals(this.certificationRequirementsVersion, that.certificationRequirementsVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.effectiveDate, this.certificate, this.url, this.certificationDescriptor, this.certificateNumber, this.certificationPolicyVersion, this.certificationRequirementsVersion});
    }
}

