/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.metadata.CachingMetadataBLOBProvider;
import com.webauthn4j.metadata.CertPathCheckContext;
import com.webauthn4j.metadata.CertPathChecker;
import com.webauthn4j.metadata.HttpClient;
import com.webauthn4j.metadata.SimpleHttpClient;
import com.webauthn4j.metadata.data.MetadataBLOB;
import com.webauthn4j.metadata.data.MetadataBLOBFactory;
import com.webauthn4j.metadata.exception.CertPathCheckException;
import com.webauthn4j.metadata.exception.MDSException;
import com.webauthn4j.util.CertificateUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FidoMDS3MetadataBLOBProvider
extends CachingMetadataBLOBProvider {
    public static final String DEFAULT_BLOB_ENDPOINT = "https://mds.fidoalliance.org/";
    private final MetadataBLOBFactory metadataBLOBFactory;
    private final String blobEndpoint;
    private final HttpClient httpClient;
    private final Set<TrustAnchor> trustAnchors;
    private boolean revocationCheckEnabled = true;
    private CertPathChecker certPathChecker = new DefaultCertPathChecker();

    public FidoMDS3MetadataBLOBProvider(@NotNull ObjectConverter objectConverter, @NotNull String blobEndpoint, @NotNull HttpClient httpClient, @NotNull Set<TrustAnchor> trustAnchors) {
        this.metadataBLOBFactory = new MetadataBLOBFactory(objectConverter);
        this.blobEndpoint = blobEndpoint;
        this.httpClient = httpClient;
        this.trustAnchors = trustAnchors;
    }

    public FidoMDS3MetadataBLOBProvider(@NotNull ObjectConverter objectConverter, @NotNull String blobEndpoint, @NotNull Set<TrustAnchor> trustAnchors) {
        this(objectConverter, blobEndpoint, new SimpleHttpClient(), trustAnchors);
    }

    public FidoMDS3MetadataBLOBProvider(@NotNull ObjectConverter objectConverter, @NotNull String blobEndpoint, @NotNull X509Certificate trustAnchorCertificate) {
        this(objectConverter, blobEndpoint, Collections.singleton(new TrustAnchor(trustAnchorCertificate, null)));
    }

    public FidoMDS3MetadataBLOBProvider(@NotNull ObjectConverter objectConverter, @NotNull Set<TrustAnchor> trustAnchors) {
        this(objectConverter, DEFAULT_BLOB_ENDPOINT, trustAnchors);
    }

    public FidoMDS3MetadataBLOBProvider(@NotNull ObjectConverter objectConverter, @NotNull X509Certificate trustAnchorCertificate) {
        this(objectConverter, Collections.singleton(new TrustAnchor(trustAnchorCertificate, null)));
    }

    @Override
    @NotNull
    protected MetadataBLOB doProvide() {
        String responseBody = this.httpClient.fetch(this.blobEndpoint);
        MetadataBLOB metadataBLOB = this.metadataBLOBFactory.parse(responseBody);
        if (!metadataBLOB.isValidSignature()) {
            throw new MDSException("MetadataBLOB signature is invalid");
        }
        this.validateCertPath(metadataBLOB);
        return metadataBLOB;
    }

    private void validateCertPath(@NotNull MetadataBLOB metadataBLOB) {
        CertPath certPath = metadataBLOB.getHeader().getX5c();
        try {
            this.certPathChecker.check(new CertPathCheckContext(certPath, this.trustAnchors, this.revocationCheckEnabled));
        }
        catch (CertPathCheckException e) {
            throw new MDSException("MetadataBLOB certificate chain validation failed", e);
        }
    }

    public boolean isRevocationCheckEnabled() {
        return this.revocationCheckEnabled;
    }

    public void setRevocationCheckEnabled(boolean revocationCheckEnabled) {
        this.revocationCheckEnabled = revocationCheckEnabled;
    }

    @NotNull
    public CertPathChecker getCertPathChecker() {
        return this.certPathChecker;
    }

    public void setCertPathChecker(@NotNull CertPathChecker certPathChecker) {
        this.certPathChecker = certPathChecker;
    }

    private class DefaultCertPathChecker
    implements CertPathChecker {
        private DefaultCertPathChecker() {
        }

        @Override
        public void check(CertPathCheckContext context) throws MDSException {
            CertPathValidator certPathValidator = CertificateUtil.createCertPathValidator();
            PKIXParameters certPathParameters = CertificateUtil.createPKIXParameters(FidoMDS3MetadataBLOBProvider.this.trustAnchors);
            certPathParameters.setRevocationEnabled(FidoMDS3MetadataBLOBProvider.this.revocationCheckEnabled);
            if (FidoMDS3MetadataBLOBProvider.this.revocationCheckEnabled) {
                PKIXRevocationChecker pkixRevocationChecker = (PKIXRevocationChecker)certPathValidator.getRevocationChecker();
                pkixRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS));
                certPathParameters.addCertPathChecker(pkixRevocationChecker);
            }
            try {
                certPathValidator.validate(context.getCertPath(), certPathParameters);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CertPathCheckException("invalid algorithm parameter", e);
            }
            catch (CertPathValidatorException e) {
                throw new CertPathCheckException("invalid cert path", e);
            }
        }
    }
}

