/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.server;

import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.springframework.security.challenge.ChallengeRepository;
import com.webauthn4j.springframework.security.options.RpIdProvider;
import com.webauthn4j.springframework.security.options.RpIdProviderImpl;
import com.webauthn4j.springframework.security.server.ServerPropertyProvider;
import com.webauthn4j.springframework.security.util.internal.ServletUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;

public class ServerPropertyProviderImpl
implements ServerPropertyProvider {
    private String rpId;
    private RpIdProvider rpIdProvider;
    private RpIdProvider defaultRpIdProvider = new RpIdProviderImpl();
    private final ChallengeRepository challengeRepository;

    public ServerPropertyProviderImpl(RpIdProvider rpIdProvider, ChallengeRepository challengeRepository) {
        Assert.notNull((Object)challengeRepository, (String)"challengeRepository must not be null");
        this.rpIdProvider = rpIdProvider;
        this.challengeRepository = challengeRepository;
    }

    public ServerPropertyProviderImpl(ChallengeRepository challengeRepository) {
        this(null, challengeRepository);
    }

    @Override
    public ServerProperty provide(HttpServletRequest request) {
        Origin origin = ServletUtil.getOrigin((ServletRequest)request);
        String effectiveRpId = this.getRpId(request);
        Challenge challenge = this.challengeRepository.loadOrGenerateChallenge(request);
        return new ServerProperty(origin, effectiveRpId, challenge, null);
    }

    public String getRpId() {
        return this.rpId;
    }

    public void setRpId(String rpId) {
        this.rpId = rpId;
    }

    String getRpId(HttpServletRequest request) {
        if (this.rpIdProvider != null) {
            return this.rpIdProvider.provide(request);
        }
        if (this.rpId != null) {
            return this.rpId;
        }
        return this.defaultRpIdProvider.provide(request);
    }

    public RpIdProvider getRpIdProvider() {
        return this.rpIdProvider;
    }

    public void setRpIdProvider(RpIdProvider rpIdProvider) {
        this.rpIdProvider = rpIdProvider;
    }
}

