/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.util.internal;

import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.springframework.security.exception.BadAaguidException;
import com.webauthn4j.springframework.security.exception.BadAlgorithmException;
import com.webauthn4j.springframework.security.exception.BadAttestationStatementException;
import com.webauthn4j.springframework.security.exception.BadOriginException;
import com.webauthn4j.springframework.security.exception.BadRpIdException;
import com.webauthn4j.springframework.security.exception.BadStatusException;
import com.webauthn4j.springframework.security.exception.CertificateException;
import com.webauthn4j.springframework.security.exception.InconsistentClientDataTypeException;
import com.webauthn4j.springframework.security.exception.MaliciousCounterValueException;
import com.webauthn4j.springframework.security.exception.TrustAnchorNotFoundException;
import com.webauthn4j.springframework.security.exception.UnexpectedExtensionException;
import com.webauthn4j.util.exception.WebAuthnException;
import com.webauthn4j.validator.exception.BadChallengeException;
import com.webauthn4j.validator.exception.BadSignatureException;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.KeyDescriptionValidationException;
import com.webauthn4j.validator.exception.MissingChallengeException;
import com.webauthn4j.validator.exception.PublicKeyMismatchException;
import com.webauthn4j.validator.exception.SelfAttestationProhibitedException;
import com.webauthn4j.validator.exception.TokenBindingException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import com.webauthn4j.validator.exception.ValidationException;
import org.springframework.security.authentication.AuthenticationServiceException;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static RuntimeException wrapWithAuthenticationException(WebAuthnException e) {
        if (e instanceof com.webauthn4j.validator.exception.BadAaguidException) {
            return new BadAaguidException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.validator.exception.BadAlgorithmException) {
            return new BadAlgorithmException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.validator.exception.BadAttestationStatementException) {
            if (e instanceof KeyDescriptionValidationException) {
                return new com.webauthn4j.springframework.security.exception.KeyDescriptionValidationException(e.getMessage(), (Throwable)e);
            }
            return new BadAttestationStatementException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof BadChallengeException) {
            return new com.webauthn4j.springframework.security.exception.BadChallengeException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.validator.exception.BadOriginException) {
            return new BadOriginException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.validator.exception.BadRpIdException) {
            return new BadRpIdException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof BadSignatureException) {
            return new com.webauthn4j.springframework.security.exception.BadSignatureException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.metadata.exception.BadStatusException) {
            return new BadStatusException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.validator.exception.CertificateException) {
            return new CertificateException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof ConstraintViolationException) {
            return new com.webauthn4j.springframework.security.exception.ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.validator.exception.MaliciousCounterValueException) {
            return new MaliciousCounterValueException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.validator.exception.InconsistentClientDataTypeException) {
            return new InconsistentClientDataTypeException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof MissingChallengeException) {
            return new com.webauthn4j.springframework.security.exception.MissingChallengeException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof PublicKeyMismatchException) {
            return new com.webauthn4j.springframework.security.exception.PublicKeyMismatchException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof SelfAttestationProhibitedException) {
            return new com.webauthn4j.springframework.security.exception.SelfAttestationProhibitedException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof TokenBindingException) {
            return new com.webauthn4j.springframework.security.exception.TokenBindingException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.validator.exception.TrustAnchorNotFoundException) {
            return new TrustAnchorNotFoundException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.validator.exception.UnexpectedExtensionException) {
            return new UnexpectedExtensionException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof UserNotPresentException) {
            return new com.webauthn4j.springframework.security.exception.UserNotPresentException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof UserNotVerifiedException) {
            return new com.webauthn4j.springframework.security.exception.UserNotVerifiedException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof ValidationException) {
            return new com.webauthn4j.springframework.security.exception.ValidationException("WebAuthn validation error", (Throwable)e);
        }
        if (e instanceof DataConversionException) {
            return new com.webauthn4j.springframework.security.exception.DataConversionException("WebAuthn data conversion error", (Throwable)e);
        }
        return new AuthenticationServiceException(null, (Throwable)e);
    }
}

