/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test;

import com.webauthn4j.data.client.Origin;
import com.webauthn4j.test.authenticator.AuthenticatorAdaptor;
import com.webauthn4j.test.authenticator.u2f.FIDOU2FAuthenticator;
import com.webauthn4j.test.authenticator.u2f.FIDOU2FAuthenticatorAdaptor;
import com.webauthn4j.test.authenticator.webauthn.AndroidKeyAuthenticator;
import com.webauthn4j.test.authenticator.webauthn.AndroidSafetyNetAuthenticator;
import com.webauthn4j.test.authenticator.webauthn.PackedAuthenticator;
import com.webauthn4j.test.authenticator.webauthn.TPMAuthenticator;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnAuthenticatorAdaptor;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnModelAuthenticator;
import com.webauthn4j.test.client.ClientPlatform;

public class EmulatorUtil {
    public static final PackedAuthenticator PACKED_AUTHENTICATOR = new PackedAuthenticator();
    public static final AndroidKeyAuthenticator ANDROID_KEY_AUTHENTICATOR = new AndroidKeyAuthenticator();
    public static final AndroidSafetyNetAuthenticator ANDROID_SAFETY_NET_AUTHENTICATOR = new AndroidSafetyNetAuthenticator();
    public static final TPMAuthenticator TPM_AUTHENTICATOR = new TPMAuthenticator();
    public static final FIDOU2FAuthenticator FIDO_U2F_AUTHENTICATOR = new FIDOU2FAuthenticator();
    private static final Origin origin = new Origin("http://example.com");

    private EmulatorUtil() {
    }

    public static ClientPlatform createClientPlatform(AuthenticatorAdaptor authenticatorAdaptor) {
        return new ClientPlatform(origin, authenticatorAdaptor);
    }

    public static ClientPlatform createClientPlatform(WebAuthnModelAuthenticator webAuthnModelAuthenticator) {
        WebAuthnAuthenticatorAdaptor webAuthnAuthenticatorAdaptor = new WebAuthnAuthenticatorAdaptor(webAuthnModelAuthenticator);
        return EmulatorUtil.createClientPlatform(webAuthnAuthenticatorAdaptor);
    }

    public static ClientPlatform createClientPlatform(FIDOU2FAuthenticator fidoU2FAuthenticator) {
        FIDOU2FAuthenticatorAdaptor fidou2FAuthenticatorAdaptor = new FIDOU2FAuthenticatorAdaptor(fidoU2FAuthenticator);
        return EmulatorUtil.createClientPlatform(fidou2FAuthenticatorAdaptor);
    }

    public static ClientPlatform createClientPlatform() {
        return EmulatorUtil.createClientPlatform(new PackedAuthenticator());
    }
}

