/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.AssertUtil;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;

public class SignatureUtil {
    private static Signature ES256 = SignatureUtil.createSignature("SHA256withECDSA");
    private static Signature RS256 = SignatureUtil.createSignature("SHA256withRSA");

    private SignatureUtil() {
    }

    public static Signature getRS256() {
        return RS256;
    }

    public static Signature getES256() {
        return ES256;
    }

    public static Signature createSignature(String algorithm) {
        AssertUtil.notNull(algorithm, "algorithm is required; it must not be null");
        try {
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

