/*
 * Decompiled with CFR 0.152.
 */
package com.webcerebrium.slack;

import com.webcerebrium.slack.NotificationConfig;
import com.webcerebrium.slack.NotificationException;
import com.webcerebrium.slack.SlackMessage;
import com.webcerebrium.slack.SlackRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notification {
    private static final Logger log = LoggerFactory.getLogger(Notification.class);
    String channelUrl;

    public Notification() {
        NotificationConfig config = new NotificationConfig();
        this.channelUrl = config.getVariable("SLACK_NOTIFICATION_URL");
        log.info("channelUrl={}", (Object)this.channelUrl);
    }

    public Notification(String channelUrl) {
        this.channelUrl = channelUrl;
    }

    public String send(SlackMessage message) throws NotificationException {
        SlackRequest request = new SlackRequest();
        return request.connect(this.channelUrl).post().payload(message.toJson()).read().getLastResponse();
    }

    public String getChannelUrl() {
        return this.channelUrl;
    }

    public void setChannelUrl(String channelUrl) {
        this.channelUrl = channelUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$channelUrl = this.getChannelUrl();
        String other$channelUrl = other.getChannelUrl();
        return !(this$channelUrl == null ? other$channelUrl != null : !this$channelUrl.equals(other$channelUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Notification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $channelUrl = this.getChannelUrl();
        result = result * 59 + ($channelUrl == null ? 0 : $channelUrl.hashCode());
        return result;
    }

    public String toString() {
        return "Notification(channelUrl=" + this.getChannelUrl() + ")";
    }
}

