/*
 * Decompiled with CFR 0.152.
 */
package com.webcerebrium.slack;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.webcerebrium.slack.SlackMessageAttachment;
import java.util.LinkedList;
import java.util.List;

public class SlackMessage {
    public String text;
    public List<SlackMessageAttachment> attachments = new LinkedList<SlackMessageAttachment>();

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        if (!Strings.isNullOrEmpty((String)this.text)) {
            obj.addProperty("text", this.text);
        }
        if (this.attachments != null && this.attachments.size() > 0) {
            JsonArray arrAttachments = new JsonArray();
            for (SlackMessageAttachment msg : this.attachments) {
                arrAttachments.add((JsonElement)msg.toJson());
            }
            obj.add("attachments", (JsonElement)arrAttachments);
        }
        return obj;
    }

    public String getText() {
        return this.text;
    }

    public List<SlackMessageAttachment> getAttachments() {
        return this.attachments;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAttachments(List<SlackMessageAttachment> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackMessage)) {
            return false;
        }
        SlackMessage other = (SlackMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<SlackMessageAttachment> this$attachments = this.getAttachments();
        List<SlackMessageAttachment> other$attachments = other.getAttachments();
        return !(this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 0 : $text.hashCode());
        List<SlackMessageAttachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 0 : ((Object)$attachments).hashCode());
        return result;
    }

    public String toString() {
        return "SlackMessage(text=" + this.getText() + ", attachments=" + this.getAttachments() + ")";
    }
}

