/*
 * Decompiled with CFR 0.152.
 */
package com.webcerebrium.slack;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;

public class SlackMessageAttachment {
    public String title = "";
    public String text = "";
    public String color = "#888";
    public JsonArray markdown = new JsonArray();

    public SlackMessageAttachment() {
    }

    public SlackMessageAttachment(String title, String text, String color) {
        this.title = title;
        this.text = text;
        this.color = color;
    }

    public SlackMessageAttachment addMarkdown(Set<String> m) {
        for (String s : m) {
            this.markdown.add(s);
        }
        return this;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        if (!Strings.isNullOrEmpty((String)this.title)) {
            obj.addProperty("title", this.title);
        }
        if (!Strings.isNullOrEmpty((String)this.text)) {
            obj.addProperty("text", this.text);
        }
        if (!Strings.isNullOrEmpty((String)this.color)) {
            obj.addProperty("color", this.color);
        }
        if (this.markdown != null && this.markdown.size() > 0) {
            obj.add("mrkdwn_in", (JsonElement)this.getMarkdown());
        }
        return obj;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public String getColor() {
        return this.color;
    }

    public JsonArray getMarkdown() {
        return this.markdown;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setMarkdown(JsonArray markdown) {
        this.markdown = markdown;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackMessageAttachment)) {
            return false;
        }
        SlackMessageAttachment other = (SlackMessageAttachment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        JsonArray this$markdown = this.getMarkdown();
        JsonArray other$markdown = other.getMarkdown();
        return !(this$markdown == null ? other$markdown != null : !this$markdown.equals(other$markdown));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackMessageAttachment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 0 : $title.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 0 : $text.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 0 : $color.hashCode());
        JsonArray $markdown = this.getMarkdown();
        result = result * 59 + ($markdown == null ? 0 : $markdown.hashCode());
        return result;
    }

    public String toString() {
        return "SlackMessageAttachment(title=" + this.getTitle() + ", text=" + this.getText() + ", color=" + this.getColor() + ", markdown=" + this.getMarkdown() + ")";
    }
}

