/*
 * Decompiled with CFR 0.152.
 */
package com.webcerebrium.slack;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.webcerebrium.slack.NotificationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackRequest {
    private static final Logger log = LoggerFactory.getLogger(SlackRequest.class);
    public String userAgent = "Mozilla/5.0 (Windows NT 5.1; rv:19.0) Gecko/20100101 Firefox/19.0";
    public HttpsURLConnection conn = null;
    public String requestUrl = "";
    public String method = "GET";
    public String lastResponse = "";
    public Map<String, String> headers = new HashMap<String, String>();
    private JsonParser jsonParser = new JsonParser();
    private String requestBody = "";

    public SlackRequest post() {
        this.setMethod("POST");
        return this;
    }

    public SlackRequest put() {
        this.setMethod("PUT");
        return this;
    }

    public SlackRequest delete() {
        this.setMethod("DELETE");
        return this;
    }

    public SlackRequest connect(String requestUrl) throws NotificationException {
        this.requestUrl = requestUrl;
        if (Strings.isNullOrEmpty((String)requestUrl)) {
            throw new NotificationException("Slack Request URL is not provided");
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        URL url = null;
        try {
            url = new URL(requestUrl);
            log.debug("{} {}", (Object)this.getMethod(), (Object)url);
        }
        catch (MalformedURLException e) {
            throw new NotificationException("Mailformed URL " + e.getMessage());
        }
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (NoSuchAlgorithmException e) {
            throw new NotificationException("SSL Error " + e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new NotificationException("Key Management Error " + e.getMessage());
        }
        try {
            this.conn = (HttpsURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw new NotificationException("HTTPS Connection error " + e.getMessage());
        }
        try {
            this.conn.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            throw new NotificationException("HTTP method error " + e.getMessage());
        }
        this.conn.setRequestProperty("User-Agent", this.getUserAgent());
        for (String header : this.headers.keySet()) {
            this.conn.setRequestProperty(header, this.headers.get(header));
        }
        return this;
    }

    public SlackRequest read() throws NotificationException {
        if (this.conn == null) {
            throw new NotificationException("Must be connected before reading");
        }
        try {
            JsonObject obj;
            if (!Strings.isNullOrEmpty((String)this.getRequestBody())) {
                log.debug("Payload: {}", (Object)this.getRequestBody());
                this.conn.setDoInput(true);
                this.conn.setDoOutput(true);
                OutputStreamWriter writer = new OutputStreamWriter(this.conn.getOutputStream(), "UTF-8");
                writer.write(this.getRequestBody());
                writer.close();
            }
            InputStream is = this.conn.getResponseCode() < 400 ? this.conn.getInputStream() : this.conn.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            this.lastResponse = IOUtils.toString((Reader)br);
            log.debug("Response: {}", (Object)this.lastResponse);
            if (this.conn.getResponseCode() >= 400 && (obj = (JsonObject)this.jsonParser.parse(this.lastResponse)).has("code") && obj.has("msg")) {
                throw new NotificationException("ERROR: " + obj.get("code").getAsString() + ", " + obj.get("msg").getAsString());
            }
        }
        catch (IOException e) {
            throw new NotificationException("Error in reading response " + e.getMessage());
        }
        return this;
    }

    public SlackRequest payload(JsonObject payload) {
        if (payload == null) {
            return this;
        }
        this.requestBody = payload.toString();
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Content-Length", String.valueOf(this.requestBody.length()));
        return this;
    }

    public JsonObject asJsonObject() {
        return (JsonObject)this.jsonParser.parse(this.getLastResponse());
    }

    public JsonArray asJsonArray() {
        return (JsonArray)this.jsonParser.parse(this.getLastResponse());
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public HttpsURLConnection getConn() {
        return this.conn;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getMethod() {
        return this.method;
    }

    public String getLastResponse() {
        return this.lastResponse;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public JsonParser getJsonParser() {
        return this.jsonParser;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setConn(HttpsURLConnection conn) {
        this.conn = conn;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setLastResponse(String lastResponse) {
        this.lastResponse = lastResponse;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setJsonParser(JsonParser jsonParser) {
        this.jsonParser = jsonParser;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackRequest)) {
            return false;
        }
        SlackRequest other = (SlackRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        HttpsURLConnection this$conn = this.getConn();
        HttpsURLConnection other$conn = other.getConn();
        if (this$conn == null ? other$conn != null : !this$conn.equals(other$conn)) {
            return false;
        }
        String this$requestUrl = this.getRequestUrl();
        String other$requestUrl = other.getRequestUrl();
        if (this$requestUrl == null ? other$requestUrl != null : !this$requestUrl.equals(other$requestUrl)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$lastResponse = this.getLastResponse();
        String other$lastResponse = other.getLastResponse();
        if (this$lastResponse == null ? other$lastResponse != null : !this$lastResponse.equals(other$lastResponse)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        JsonParser this$jsonParser = this.getJsonParser();
        JsonParser other$jsonParser = other.getJsonParser();
        if (this$jsonParser == null ? other$jsonParser != null : !this$jsonParser.equals(other$jsonParser)) {
            return false;
        }
        String this$requestBody = this.getRequestBody();
        String other$requestBody = other.getRequestBody();
        return !(this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 0 : $userAgent.hashCode());
        HttpsURLConnection $conn = this.getConn();
        result = result * 59 + ($conn == null ? 0 : $conn.hashCode());
        String $requestUrl = this.getRequestUrl();
        result = result * 59 + ($requestUrl == null ? 0 : $requestUrl.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 0 : $method.hashCode());
        String $lastResponse = this.getLastResponse();
        result = result * 59 + ($lastResponse == null ? 0 : $lastResponse.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 0 : ((Object)$headers).hashCode());
        JsonParser $jsonParser = this.getJsonParser();
        result = result * 59 + ($jsonParser == null ? 0 : $jsonParser.hashCode());
        String $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 0 : $requestBody.hashCode());
        return result;
    }

    public String toString() {
        return "SlackRequest(userAgent=" + this.getUserAgent() + ", conn=" + this.getConn() + ", requestUrl=" + this.getRequestUrl() + ", method=" + this.getMethod() + ", lastResponse=" + this.getLastResponse() + ", headers=" + this.getHeaders() + ", jsonParser=" + this.getJsonParser() + ", requestBody=" + this.getRequestBody() + ")";
    }
}

