/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.idl;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.modules.idl.JaxbSchemaFile;
import com.webcohesion.enunciate.modules.idl.JaxrsWadlFile;
import com.webcohesion.enunciate.modules.idl.JaxwsWsdlFile;
import com.webcohesion.enunciate.modules.idl.SchemaConfig;
import com.webcohesion.enunciate.modules.idl.WsdlConfig;
import com.webcohesion.enunciate.modules.jaxb.JaxbModule;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsModule;
import com.webcohesion.enunciate.modules.jaxws.JaxwsModule;
import com.webcohesion.enunciate.modules.jaxws.WsdlInfo;
import com.webcohesion.enunciate.util.StaticInterfaceDescriptionFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.configuration2.HierarchicalConfiguration;

public class IDLModule
extends BasicGeneratingModule
implements ApiFeatureProviderModule {
    JaxbModule jaxbModule;
    JaxwsModule jaxwsModule;
    JaxrsModule jaxrsModule;

    public String getName() {
        return "idl";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return List.of(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                if (module instanceof JaxbModule) {
                    IDLModule.this.jaxbModule = (JaxbModule)module;
                    return true;
                }
                if (module instanceof JaxwsModule) {
                    IDLModule.this.jaxwsModule = (JaxwsModule)module;
                    return true;
                }
                if (module instanceof JaxrsModule) {
                    IDLModule.this.jaxrsModule = (JaxrsModule)module;
                    return true;
                }
                return false;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "optional jaxb, optional jaxws, optional jaxrs";
            }
        });
    }

    public Map<String, SchemaConfig> getSchemaConfigs() {
        HashMap<String, SchemaConfig> configs = new HashMap<String, SchemaConfig>();
        List schemas = this.config.configurationsAt("schema");
        for (HierarchicalConfiguration schema : schemas) {
            SchemaConfig schemaConfig = new SchemaConfig();
            schemaConfig.setAppinfo(schema.getString("[@appinfo]", null));
            schemaConfig.setFilename(schema.getString("[@filename]", null));
            schemaConfig.setJaxbBindingVersion(schema.getString("[@jaxbBindingVersion]", null));
            schemaConfig.setLocation(schema.getString("[@location]", null));
            String ns = schema.getString("[@namespace]", null);
            if ("".equals(ns)) {
                ns = null;
            }
            schemaConfig.setNamespace(ns);
            String useFile = schema.getString("[@useFile]", null);
            if (useFile != null) {
                File file = this.resolveFile(useFile);
                if (!file.exists()) {
                    throw new EnunciateException(String.format("Invalid schema config: file %s does not exist.", useFile));
                }
                schemaConfig.setUseFile(file);
            }
            configs.put(schemaConfig.getNamespace(), schemaConfig);
        }
        return configs;
    }

    public Map<String, WsdlConfig> getWsdlConfigs() {
        HashMap<String, WsdlConfig> configs = new HashMap<String, WsdlConfig>();
        List wsdls = this.config.configurationsAt("wsdl");
        for (HierarchicalConfiguration wsdl : wsdls) {
            WsdlConfig wsdlConfig = new WsdlConfig();
            wsdlConfig.setFilename(wsdl.getString("[@filename]", null));
            wsdlConfig.setNamespace(wsdl.getString("[@namespace]", null));
            wsdlConfig.setInlineSchema(wsdl.getBoolean("[@inlineSchema]", true));
            String useFile = wsdl.getString("[@useFile]", null);
            if (useFile != null) {
                File file = this.resolveFile(useFile);
                if (!file.exists()) {
                    throw new EnunciateException(String.format("Invalid wsdl config: file %s does not exist.", useFile));
                }
                wsdlConfig.setUseFile(file);
            }
            configs.put(wsdlConfig.getNamespace(), wsdlConfig);
        }
        return configs;
    }

    public void call(EnunciateContext context) {
        Map ns2schema = Collections.emptyMap();
        Map ns2prefix = Collections.emptyMap();
        if (this.jaxbModule != null) {
            ns2schema = this.jaxbModule.getJaxbContext().getSchemas();
            ns2prefix = this.jaxbModule.getJaxbContext().getNamespacePrefixes();
        }
        Map ns2wsdl = Collections.emptyMap();
        if (this.jaxwsModule != null) {
            ns2wsdl = this.jaxwsModule.getJaxwsContext().getWsdls();
        }
        TreeSet<String> facetIncludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetIncludes());
        facetIncludes.addAll(this.getFacetIncludes());
        TreeSet<String> facetExcludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetExcludes());
        facetExcludes.addAll(this.getFacetExcludes());
        FacetFilter facetFilter = new FacetFilter(facetIncludes, facetExcludes);
        Map<String, SchemaConfig> schemaConfigs = this.getSchemaConfigs();
        for (SchemaInfo schemaInfo : ns2schema.values()) {
            String defaultFilename = (String)ns2prefix.get(schemaInfo.getNamespace()) + ".xsd";
            SchemaConfig explicitConfig = schemaConfigs.get(schemaInfo.getNamespace());
            if (explicitConfig != null && explicitConfig.getUseFile() != null) {
                schemaInfo.setFilename(explicitConfig.getUseFile().getName());
                schemaInfo.setSchemaFile((InterfaceDescriptionFile)new StaticInterfaceDescriptionFile(explicitConfig.getUseFile(), this.enunciate));
                continue;
            }
            if (explicitConfig != null) {
                schemaInfo.setAppinfo(explicitConfig.getAppinfo());
                schemaInfo.setFilename((String)(explicitConfig.getFilename() != null ? explicitConfig.getFilename() : defaultFilename));
                schemaInfo.setExplicitLocation(explicitConfig.getLocation());
                schemaInfo.setJaxbBindingVersion(explicitConfig.getJaxbBindingVersion());
                schemaInfo.setSchemaFile((InterfaceDescriptionFile)new JaxbSchemaFile(this.enunciate, defaultFilename, this.jaxbModule.getJaxbContext(), schemaInfo, facetFilter, ns2prefix));
                continue;
            }
            schemaInfo.setFilename(defaultFilename);
            schemaInfo.setSchemaFile((InterfaceDescriptionFile)new JaxbSchemaFile(this.enunciate, defaultFilename, this.jaxbModule.getJaxbContext(), schemaInfo, facetFilter, ns2prefix));
        }
        String baseUri = this.enunciate.getConfiguration().getApplicationRoot();
        Map<String, WsdlConfig> wsdlConfigs = this.getWsdlConfigs();
        for (WsdlInfo wsdlInfo : ns2wsdl.values()) {
            String defaultFilename = (String)ns2prefix.get(wsdlInfo.getTargetNamespace()) + ".wsdl";
            WsdlConfig explicitConfig = wsdlConfigs.get(wsdlInfo.getTargetNamespace());
            if (explicitConfig != null && explicitConfig.getUseFile() != null) {
                wsdlInfo.setFilename(explicitConfig.getUseFile().getName());
                wsdlInfo.setWsdlFile((InterfaceDescriptionFile)new StaticInterfaceDescriptionFile(explicitConfig.getUseFile(), this.enunciate));
                continue;
            }
            if (explicitConfig != null) {
                wsdlInfo.setFilename((String)(explicitConfig.getFilename() != null ? explicitConfig.getFilename() : defaultFilename));
                wsdlInfo.setInlineSchema(explicitConfig.isInlineSchema());
                wsdlInfo.setWsdlFile((InterfaceDescriptionFile)new JaxwsWsdlFile(this.enunciate, defaultFilename, wsdlInfo, this.jaxbModule.getJaxbContext(), baseUri, ns2prefix, facetFilter));
                continue;
            }
            wsdlInfo.setFilename(defaultFilename);
            wsdlInfo.setWsdlFile((InterfaceDescriptionFile)new JaxwsWsdlFile(this.enunciate, defaultFilename, wsdlInfo, this.jaxbModule.getJaxbContext(), baseUri, ns2prefix, facetFilter));
        }
        if (this.jaxrsModule != null && this.jaxbModule != null && !this.isDisableWadl()) {
            this.jaxrsModule.getJaxrsContext().setWadlFile((InterfaceDescriptionFile)new JaxrsWadlFile(this.enunciate, "application.wadl", this.jaxrsModule.getJaxrsContext(), this.jaxbModule.getJaxbContext(), new ArrayList<SchemaInfo>(ns2schema.values()), this.getWadlStylesheetUri(), baseUri, ns2prefix, facetFilter, this.isLinkJsonToXml()));
        }
    }

    public boolean isDisableWadl() {
        return this.config.getBoolean("[@disableWadl]", false);
    }

    public boolean isLinkJsonToXml() {
        return this.config.getBoolean("[@linkJsonToXml]", false);
    }

    public String getWadlStylesheetUri() {
        return this.config.getString("[@wadlStylesheetUri]", null);
    }

    public Set<String> getFacetIncludes() {
        List includes = this.config.getList("facets.include[@name]");
        TreeSet<String> facetIncludes = new TreeSet<String>();
        for (Object include : includes) {
            facetIncludes.add(String.valueOf(include));
        }
        return facetIncludes;
    }

    public Set<String> getFacetExcludes() {
        List excludes = this.config.getList("facets.exclude[@name]");
        TreeSet<String> facetExcludes = new TreeSet<String>();
        for (Object exclude : excludes) {
            facetExcludes.add(String.valueOf(exclude));
        }
        return facetExcludes;
    }
}

