/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.EnunciateLogger;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jackson.api.impl.ExampleImpl;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.EnumValue;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonTypeFactory;
import com.webcohesion.enunciate.util.ExampleUtils;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class DataTypeExampleImpl
extends ExampleImpl {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final ObjectTypeDefinition type;
    private final List<DataTypeReference.ContainerType> containers;
    private final ApiRegistrationContext registrationContext;

    public DataTypeExampleImpl(ObjectTypeDefinition type, ApiRegistrationContext registrationContext) {
        this(type, null, registrationContext);
    }

    public DataTypeExampleImpl(ObjectTypeDefinition typeDefinition, List<DataTypeReference.ContainerType> containers, ApiRegistrationContext registrationContext) {
        this.type = typeDefinition;
        this.containers = containers == null ? Collections.emptyList() : containers;
        this.registrationContext = registrationContext;
    }

    @Override
    public String getBody() {
        ObjectNode wrappedNode;
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        Context context = new Context();
        context.stack = new LinkedList();
        this.build(node, this.type, this.type, context);
        if (this.type.getContext().isWrapRootValue()) {
            wrappedNode = JsonNodeFactory.instance.objectNode();
            wrappedNode.set(this.type.getJsonRootName(), (JsonNode)node);
            node = wrappedNode;
        }
        if (this.isWrappedSubclass(this.type)) {
            wrappedNode = JsonNodeFactory.instance.objectNode();
            wrappedNode.set(this.type.getTypeIdValue(), (JsonNode)node);
            node = wrappedNode;
        }
        ObjectNode outer = node;
        for (DataTypeReference.ContainerType container : this.containers) {
            switch (container) {
                case array: 
                case collection: 
                case list: {
                    ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
                    arrayNode.add((JsonNode)outer);
                    outer = arrayNode;
                    break;
                }
                case map: {
                    ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
                    mapNode.set("...", (JsonNode)outer);
                    outer = mapNode;
                }
            }
        }
        try {
            return MAPPER.writeValueAsString((Object)outer);
        }
        catch (JsonProcessingException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    private boolean isWrappedSubclass(ObjectTypeDefinition type) {
        if (type.isAbstract() || type.isInterface()) {
            return false;
        }
        JsonType supertype = type.getSupertype();
        if (supertype instanceof JsonClassType) {
            TypeDefinition typeDefinition = ((JsonClassType)supertype).getTypeDefinition();
            if (typeDefinition.getTypeIdInclusion() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                return true;
            }
            if (typeDefinition instanceof ObjectTypeDefinition) {
                return this.isWrappedSubclass((ObjectTypeDefinition)typeDefinition);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void build(ObjectNode node, ObjectTypeDefinition type, @Nonnull ObjectTypeDefinition sourceType, Context context) {
        JsonNode override;
        if (context.stack.size() > 2) {
            return;
        }
        if (type.getTypeIdInclusion() == JsonTypeInfo.As.PROPERTY && type.getTypeIdProperty() != null) {
            node.put(type.getTypeIdProperty(), sourceType.getTypeIdValue());
        }
        if ((override = this.findExampleOverride((DecoratedElement)type, type.getContext().getContext().getLogger())) != null) {
            if (override instanceof ObjectNode) {
                node.setAll((ObjectNode)override);
                return;
            }
            type.getContext().getContext().getLogger().warn("JSON example override of %s can't be used because it's not a JSON object.", new Object[]{type.getQualifiedName()});
        }
        FacetFilter facetFilter = this.registrationContext.getFacetFilter();
        for (Member member : type.getMembers()) {
            String configuredExample;
            String specifiedTypeInfoValue;
            DocumentationExample documentationExample;
            String tag;
            if (node.has(member.getName()) || !facetFilter.accept((HasFacets)member) || ElementUtils.findDeprecationMessage((DecoratedElement)member, null) != null) continue;
            JsonNode memberOverride = this.findExampleOverride(member, type.getContext().getContext().getLogger());
            if (memberOverride != null) {
                node.set(member.getName(), memberOverride);
                continue;
            }
            String example = null;
            String example2 = null;
            JsonType exampleType = null;
            JavaDoc.JavaDocTagList tags = this.getDocumentationExampleTags(member);
            if (tags != null && tags.size() > 0) {
                tag = ((String)tags.get(0)).trim();
                example2 = example = tag.isEmpty() ? null : tag;
                if (tags.size() > 1) {
                    tag = ((String)tags.get(1)).trim();
                    String string = example2 = tag.isEmpty() ? null : tag;
                }
            }
            if ((tags = (JavaDoc.JavaDocTagList)member.getJavaDoc().get((Object)"documentationType")) != null && tags.size() > 0 && !(tag = ((String)tags.get(0)).trim()).isEmpty()) {
                TypeElement typeElement = type.getContext().getContext().getProcessingEnvironment().getElementUtils().getTypeElement(tag);
                if (typeElement != null) {
                    exampleType = JsonTypeFactory.getJsonType(typeElement.asType(), type.getContext());
                } else {
                    type.getContext().getContext().getLogger().warn("Invalid documentation type %s.", new Object[]{tag});
                }
            }
            if ((documentationExample = this.getDocumentationExample(member)) != null) {
                if (documentationExample.exclude()) continue;
                example = documentationExample.value();
                example = "##default".equals(example) ? null : example;
                example2 = documentationExample.value2();
                example2 = "##default".equals(example2) ? null : example2;
                TypeMirror typeHint = TypeHintUtils.getTypeHint((TypeHint)documentationExample.type(), (DecoratedProcessingEnvironment)type.getContext().getContext().getProcessingEnvironment(), null);
                if (typeHint != null) {
                    exampleType = JsonTypeFactory.getJsonType(typeHint, type.getContext());
                }
            }
            if ((specifiedTypeInfoValue = this.findSpecifiedTypeInfoValue(member, type.getQualifiedName().toString(), type)) != null) {
                example = specifiedTypeInfoValue;
                example2 = specifiedTypeInfoValue;
            }
            if ((configuredExample = this.getConfiguredExample(member)) != null) {
                example = configuredExample;
                example2 = configuredExample;
            }
            if (context.currentIndex % 2 > 0) {
                String placeholder = example2;
                example2 = example;
                example = placeholder;
            }
            if (member.getChoices().size() > 1) {
                ArrayNode wrapperNode;
                String choiceName;
                JsonType jsonType;
                if (member.isCollectionType()) {
                    ArrayNode exampleNode = JsonNodeFactory.instance.arrayNode();
                    for (Member member2 : member.getChoices()) {
                        jsonType = exampleType == null ? member2.getJsonType() : exampleType;
                        choiceName = member2.getName();
                        if ("".equals(choiceName)) {
                            choiceName = "...";
                        }
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_ARRAY) {
                            wrapperNode = JsonNodeFactory.instance.arrayNode();
                            wrapperNode.add(choiceName);
                            wrapperNode.add(this.exampleNode(jsonType, example, example2, context));
                            exampleNode.add((JsonNode)wrapperNode);
                            continue;
                        }
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                            wrapperNode = JsonNodeFactory.instance.objectNode();
                            wrapperNode.set(choiceName, this.exampleNode(jsonType, example, example2, context));
                            exampleNode.add((JsonNode)wrapperNode);
                            continue;
                        }
                        JsonNode itemNode = this.exampleNode(jsonType, example, example2, context);
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.PROPERTY) {
                            if (member.getSubtypeIdProperty() != null && itemNode instanceof ObjectNode) {
                                ((ObjectNode)itemNode).put(member.getSubtypeIdProperty(), "...");
                            }
                        } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.EXTERNAL_PROPERTY && member.getSubtypeIdProperty() != null) {
                            node.put(member.getSubtypeIdProperty(), "...");
                        }
                        exampleNode.add(itemNode);
                    }
                    node.set(member.getName(), (JsonNode)exampleNode);
                    continue;
                }
                for (Member member3 : member.getChoices()) {
                    void var19_26;
                    jsonType = exampleType == null ? member3.getJsonType() : exampleType;
                    choiceName = member3.getName();
                    if ("".equals(choiceName)) {
                        choiceName = "...";
                    }
                    if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_ARRAY) {
                        wrapperNode = JsonNodeFactory.instance.arrayNode();
                        wrapperNode.add(choiceName);
                        wrapperNode.add(this.exampleNode(jsonType, example, example2, context));
                        ArrayNode arrayNode = wrapperNode;
                    } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                        wrapperNode = JsonNodeFactory.instance.objectNode();
                        wrapperNode.set(choiceName, this.exampleNode(jsonType, example, example2, context));
                        ArrayNode arrayNode = wrapperNode;
                    } else {
                        JsonNode jsonNode = this.exampleNode(jsonType, example, example2, context);
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.PROPERTY) {
                            if (member.getSubtypeIdProperty() != null && jsonNode instanceof ObjectNode) {
                                ((ObjectNode)jsonNode).put(member.getSubtypeIdProperty(), "...");
                            }
                        } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.EXTERNAL_PROPERTY && member.getSubtypeIdProperty() != null) {
                            node.put(member.getSubtypeIdProperty(), "...");
                        }
                    }
                    node.set(member.getName(), (JsonNode)var19_26);
                }
                continue;
            }
            JsonType jsonType = exampleType == null ? member.getJsonType() : exampleType;
            node.set(member.getName(), this.exampleNode(jsonType, example, example2, context));
        }
        JsonType supertype = type.getSupertype();
        if (supertype instanceof JsonClassType && ((JsonClassType)supertype).getTypeDefinition() instanceof ObjectTypeDefinition) {
            this.build(node, (ObjectTypeDefinition)((JsonClassType)supertype).getTypeDefinition(), sourceType, context);
        }
        if (type.getWildcardMember() != null && ElementUtils.findDeprecationMessage((DecoratedElement)type.getWildcardMember(), null) == null && !ExampleUtils.isExcluded((DecoratedElement)type.getWildcardMember())) {
            node.put("extension1", "...");
            node.put("extension2", "...");
        }
    }

    private JsonNode findExampleOverride(DecoratedElement el, EnunciateLogger logger) {
        DocumentationExample annotation;
        String overrideValue = null;
        JavaDoc.JavaDocTagList overrideTags = (JavaDoc.JavaDocTagList)el.getJavaDoc().get((Object)"jsonExampleOverride");
        if (overrideTags != null && !overrideTags.isEmpty()) {
            overrideValue = (String)overrideTags.get(0);
        }
        if ((annotation = (DocumentationExample)el.getAnnotation(DocumentationExample.class)) != null && !"##default".equals(annotation.jsonOverride())) {
            overrideValue = annotation.jsonOverride();
        }
        if (overrideValue != null) {
            try {
                return MAPPER.readTree(overrideValue);
            }
            catch (Exception e) {
                logger.error("Unable to parse example override of element %s: %s", new Object[]{el.toString(), e.getMessage()});
            }
        }
        return null;
    }

    private DocumentationExample getDocumentationExample(Member member) {
        DecoratedTypeMirror accessorType;
        DocumentationExample annotation = member.getAnnotation(DocumentationExample.class);
        if (annotation == null && (accessorType = member.getBareAccessorType()) instanceof DecoratedDeclaredType) {
            annotation = ((DecoratedDeclaredType)accessorType).asElement().getAnnotation(DocumentationExample.class);
        }
        return annotation;
    }

    private JavaDoc.JavaDocTagList getDocumentationExampleTags(Member member) {
        DecoratedTypeMirror accessorType;
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)member.getJavaDoc().get((Object)"documentationExample");
        if ((tags == null || tags.isEmpty()) && (accessorType = member.getBareAccessorType()) instanceof DecoratedDeclaredType) {
            Element element = ((DecoratedDeclaredType)accessorType).asElement();
            tags = element instanceof DecoratedElement ? (JavaDoc.JavaDocTagList)((DecoratedElement)element).getJavaDoc().get((Object)"documentationExample") : null;
        }
        return tags;
    }

    private String getConfiguredExample(Member member) {
        Element element;
        String configuredExample = null;
        DecoratedTypeMirror accessorType = member.getBareAccessorType();
        if (accessorType instanceof DecoratedDeclaredType && (element = ((DecoratedDeclaredType)accessorType).asElement()) instanceof TypeElement) {
            configuredExample = member.getContext().lookupExternalExample((TypeElement)element);
        }
        return configuredExample;
    }

    private String findSpecifiedTypeInfoValue(Member member, String specifiedType, TypeDefinition type) {
        JsonType supertype;
        JsonSubTypes subTypes;
        if (type == null) {
            return null;
        }
        if (type.getTypeIdType() == JsonTypeInfo.Id.NAME && member.getSimpleName().toString().equals(type.getTypeIdProperty()) && (subTypes = (JsonSubTypes)type.getAnnotation(JsonSubTypes.class)) != null) {
            for (final JsonSubTypes.Type element : subTypes.value()) {
                DecoratedTypeMirror choiceType = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws Exception {
                        return element.value();
                    }
                }, (DecoratedProcessingEnvironment)type.getContext().getContext().getProcessingEnvironment());
                if (!choiceType.isInstanceOf(specifiedType)) continue;
                return element.name();
            }
            return null;
        }
        JsonType jsonType = supertype = type instanceof ObjectTypeDefinition ? ((ObjectTypeDefinition)type).getSupertype() : null;
        if (supertype instanceof JsonClassType) {
            return this.findSpecifiedTypeInfoValue(member, specifiedType, ((JsonClassType)supertype).getTypeDefinition());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode exampleNode(JsonType jsonType, String specifiedExample, String specifiedExample2, Context context) {
        if (jsonType instanceof JsonClassType) {
            TypeDefinition typeDefinition = ((JsonClassType)jsonType).getTypeDefinition();
            if (typeDefinition instanceof ObjectTypeDefinition) {
                ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
                if (!context.stack.contains(typeDefinition.getQualifiedName().toString())) {
                    context.stack.push(typeDefinition.getQualifiedName().toString());
                    try {
                        ObjectTypeDefinition objTypeDef = (ObjectTypeDefinition)typeDefinition;
                        this.build(objectNode, objTypeDef, objTypeDef, context);
                    }
                    finally {
                        context.stack.pop();
                    }
                }
                return objectNode;
            }
            if (typeDefinition instanceof EnumTypeDefinition) {
                String example = "???";
                if (specifiedExample != null) {
                    example = specifiedExample;
                } else {
                    List<EnumValue> enumValues = ((EnumTypeDefinition)typeDefinition).getEnumValues();
                    if (enumValues.size() > 0) {
                        int index = new Random().nextInt(enumValues.size());
                        example = enumValues.get(index).getValue();
                    }
                }
                JsonType baseType = ((EnumTypeDefinition)typeDefinition).getBaseType();
                if (baseType.isBoolean()) {
                    return JsonNodeFactory.instance.booleanNode(Boolean.valueOf(example).booleanValue());
                }
                if (baseType.isWholeNumber()) {
                    Long value;
                    try {
                        value = Long.valueOf(example);
                    }
                    catch (NumberFormatException e) {
                        value = 123456L;
                    }
                    return JsonNodeFactory.instance.numberNode(value);
                }
                if (baseType.isNumber()) {
                    Double value;
                    try {
                        value = Double.valueOf(example);
                    }
                    catch (NumberFormatException e) {
                        value = 12345.6789;
                    }
                    return JsonNodeFactory.instance.numberNode(value);
                }
                return JsonNodeFactory.instance.textNode(example);
            }
            return this.exampleNode(((SimpleTypeDefinition)typeDefinition).getBaseType(), specifiedExample, specifiedExample2, context);
        }
        if (jsonType instanceof JsonMapType) {
            int firstSpace;
            int firstSpace2;
            ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
            JsonType valueType = ((JsonMapType)jsonType).getValueType();
            String key1Example = "property1";
            if (specifiedExample != null && (firstSpace2 = JavaDoc.indexOfFirstWhitespace((String)specifiedExample)) >= 0) {
                key1Example = specifiedExample.substring(0, firstSpace2);
                if ((specifiedExample = specifiedExample.substring(firstSpace2 + 1).trim()).isEmpty()) {
                    specifiedExample = null;
                }
            }
            String key2Example = "property2";
            if (specifiedExample2 != null && (firstSpace = JavaDoc.indexOfFirstWhitespace((String)specifiedExample2)) >= 0) {
                key2Example = specifiedExample2.substring(0, firstSpace);
                if ((specifiedExample2 = specifiedExample2.substring(firstSpace + 1).trim()).isEmpty()) {
                    specifiedExample2 = null;
                }
            }
            mapNode.set(key1Example, this.exampleNode(valueType, specifiedExample, specifiedExample2, context));
            Context context2 = new Context();
            context2.stack = context.stack;
            context2.currentIndex = 1;
            mapNode.set(key2Example, this.exampleNode(valueType, specifiedExample2, specifiedExample, context2));
            return mapNode;
        }
        if (jsonType.isArray()) {
            ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
            if (jsonType instanceof JsonArrayType) {
                JsonNode componentNode = this.exampleNode(((JsonArrayType)jsonType).getComponentType(), specifiedExample, specifiedExample2, context);
                arrayNode.add(componentNode);
                Context context2 = new Context();
                context2.stack = context.stack;
                context2.currentIndex = 1;
                JsonNode componentNode2 = this.exampleNode(((JsonArrayType)jsonType).getComponentType(), specifiedExample2, specifiedExample, context2);
                arrayNode.add(componentNode2);
            }
            return arrayNode;
        }
        if (jsonType.isWholeNumber()) {
            Long example = 12345L;
            if (specifiedExample != null) {
                try {
                    example = Long.parseLong(specifiedExample);
                }
                catch (NumberFormatException e) {
                    this.type.getContext().getContext().getLogger().warn("\"%s\" was provided as a documentation example, but it is not a valid JSON whole number, so it will be ignored.", new Object[]{specifiedExample});
                }
            }
            return JsonNodeFactory.instance.numberNode(example);
        }
        if (jsonType.isNumber()) {
            Double example = 12345.0;
            if (specifiedExample != null) {
                try {
                    example = Double.parseDouble(specifiedExample);
                }
                catch (NumberFormatException e) {
                    this.type.getContext().getContext().getLogger().warn("\"%s\" was provided as a documentation example, but it is not a valid JSON number, so it will be ignored.", new Object[]{specifiedExample});
                }
            }
            return JsonNodeFactory.instance.numberNode(example);
        }
        if (jsonType.isBoolean()) {
            boolean example = !"false".equals(specifiedExample);
            return JsonNodeFactory.instance.booleanNode(example);
        }
        if (jsonType.isString()) {
            String example = specifiedExample;
            if (example == null) {
                example = "...";
            }
            return JsonNodeFactory.instance.textNode(example);
        }
        return JsonNodeFactory.instance.objectNode();
    }

    private static class Context {
        LinkedList<String> stack;
        int currentIndex = 0;

        private Context() {
        }
    }
}

