/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnum;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumValue;
import com.webcohesion.enunciate.metadata.qname.XmlUnknownQNameEnumValue;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.EnumValue;
import com.webcohesion.enunciate.modules.jackson.model.types.KnownJsonType;
import com.webcohesion.enunciate.util.AnnotationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.xml.bind.annotation.XmlSchema;

public class QNameEnumTypeDefinition
extends EnumTypeDefinition {
    private final String namespace;

    public QNameEnumTypeDefinition(TypeElement delegate, EnunciateJacksonContext context) {
        super(delegate, context);
        String namespace;
        XmlQNameEnum xmlQNameEnum = (XmlQNameEnum)this.getAnnotation(XmlQNameEnum.class);
        if (xmlQNameEnum == null) {
            throw new IllegalArgumentException(delegate.getQualifiedName() + " is not a qname enum (not annotated with @com.webcohesion.enunciate.metadata.qname.XmlQNameEnum)");
        }
        if (xmlQNameEnum.base() != XmlQNameEnum.BaseType.URI) {
            throw new EnunciateException(String.format("Qname enum %s cannot be serialized to JSON because its base is %s.", delegate, xmlQNameEnum.base()));
        }
        XmlSchema schemaInfo = this.getPackage().getAnnotation(XmlSchema.class);
        String string = namespace = schemaInfo == null ? "" : schemaInfo.namespace();
        if (!"##default".equals(xmlQNameEnum.namespace())) {
            namespace = xmlQNameEnum.namespace();
        }
        this.namespace = namespace;
    }

    @Override
    protected KnownJsonType loadBaseType(TypeElement delegate) {
        return KnownJsonType.STRING;
    }

    @Override
    protected List<EnumValue> loadEnumValues() {
        List enumConstants = this.enumValues();
        ArrayList<EnumValue> enumValueMap = new ArrayList<EnumValue>();
        HashSet<String> enumValues = new HashSet<String>(enumConstants.size());
        VariableElement unknownQNameConstant = null;
        for (VariableElement enumConstant : enumConstants) {
            String uri;
            if (AnnotationUtils.isIgnored((Element)enumConstant)) continue;
            XmlUnknownQNameEnumValue unknownQNameEnumValue = enumConstant.getAnnotation(XmlUnknownQNameEnumValue.class);
            if (unknownQNameEnumValue != null) {
                if (unknownQNameConstant != null) {
                    throw new EnunciateException(this.getQualifiedName() + ": no more than two constants can be annotated with @XmlUnknownQNameEnumValue.");
                }
                unknownQNameConstant = enumConstant;
                continue;
            }
            String ns = this.namespace;
            String localPart = enumConstant.getSimpleName().toString();
            XmlQNameEnumValue enumValueInfo = enumConstant.getAnnotation(XmlQNameEnumValue.class);
            if (enumValueInfo != null) {
                if (enumValueInfo.exclude()) continue;
                if (!"##default".equals(enumValueInfo.namespace())) {
                    ns = enumValueInfo.namespace();
                }
                if (!"##default".equals(enumValueInfo.localPart())) {
                    localPart = enumValueInfo.localPart();
                }
            }
            if (!enumValues.add(uri = ns + localPart)) {
                throw new EnunciateException(this.getQualifiedName() + ": duplicate qname enum value: " + uri);
            }
            enumValueMap.add(new EnumValue(this, enumConstant, enumConstant.getSimpleName().toString(), uri));
        }
        if (unknownQNameConstant != null) {
            enumValueMap.add(new EnumValue(this, unknownQNameConstant, unknownQNameConstant.getSimpleName().toString(), null));
        }
        return enumValueMap;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    public boolean isQNameEnum() {
        return true;
    }
}

