/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.adapters.Adaptable;
import com.webcohesion.enunciate.modules.jackson.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonTypeFactory;
import com.webcohesion.enunciate.modules.jackson.model.types.KnownJsonType;
import com.webcohesion.enunciate.modules.jackson.model.util.JacksonUtil;
import com.webcohesion.enunciate.modules.jackson.model.util.MapType;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.HasClientConvertibleType;
import com.webcohesion.enunciate.util.OptionalUtils;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public abstract class Accessor
extends DecoratedElement<Element>
implements Adaptable,
HasFacets,
HasClientConvertibleType {
    final TypeDefinition typeDefinition;
    final AdapterType adapterType;
    final Set<Facet> facets = new TreeSet<Facet>();
    final EnunciateJacksonContext context;

    public Accessor(Element delegate, TypeDefinition typeDef, EnunciateJacksonContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        this.typeDefinition = typeDef;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.facets.addAll(typeDef.getFacets());
        this.context = context;
        this.adapterType = JacksonUtil.findAdapterType((Element)((Object)this), context);
    }

    public abstract String getName();

    public String getClientSimpleName() {
        String clientSimpleName = this.delegate.getSimpleName().toString();
        ClientName clientName = this.delegate.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public DecoratedTypeMirror getAccessorType() {
        Object accessorType = (DecoratedTypeMirror)this.asType();
        accessorType = OptionalUtils.stripOptional((DecoratedTypeMirror)accessorType, (DecoratedProcessingEnvironment)this.context.getContext().getProcessingEnvironment());
        DecoratedDeclaredType normalizedCollection = JacksonUtil.getNormalizedCollection(accessorType = this.context.resolveSyntheticType((DecoratedTypeMirror)accessorType), this.context.getContext().getProcessingEnvironment());
        if (normalizedCollection != null) {
            accessorType = normalizedCollection;
        } else {
            MapType mapType = MapType.findMapType((TypeMirror)accessorType, this.context);
            if (mapType != null) {
                accessorType = mapType;
            }
        }
        return accessorType;
    }

    public TypeMirror getClientConvertibleType() {
        return this.getAccessorType();
    }

    public DecoratedTypeMirror getBareAccessorType() {
        return this.isCollectionType() ? this.getCollectionItemType() : this.getAccessorType();
    }

    public JsonType getJsonType() {
        JsonType jsonType = JsonTypeFactory.findSpecifiedType(this, this.context);
        if (jsonType != null) {
            return jsonType;
        }
        if (AnnotationUtils.isPassword((Element)((Object)this))) {
            return KnownJsonType.PASSWORD;
        }
        return JsonTypeFactory.getJsonType((TypeMirror)this.getAccessorType(), this.context);
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public DecoratedTypeMirror getResolvedAccessorType() {
        DecoratedTypeMirror accessorType = this.getAccessorType();
        if (this.isAdapted()) {
            accessorType = (DecoratedTypeMirror)this.getAdapterType().getAdaptingType(accessorType, this.context.getContext());
        }
        return accessorType;
    }

    public boolean isCollectionType() {
        DecoratedTypeMirror accessorType = this.getAccessorType();
        if (this.isAdapted()) {
            accessorType = (DecoratedTypeMirror)this.getAdapterType().getAdaptingType(accessorType, this.context.getContext());
        }
        return accessorType.isArray() || accessorType.isCollection() || accessorType.isStream();
    }

    public DecoratedTypeMirror getCollectionItemType() {
        return TypeMirrorUtils.getComponentType((DecoratedTypeMirror)this.getAccessorType(), (DecoratedProcessingEnvironment)this.context.getContext().getProcessingEnvironment());
    }

    @Override
    public boolean isAdapted() {
        return this.adapterType != null;
    }

    @Override
    public AdapterType getAdapterType() {
        return this.adapterType;
    }

    public boolean isValue() {
        return false;
    }

    public boolean isReferencesQNameEnum() {
        return this.getAnnotation(XmlQNameEnumRef.class) != null;
    }

    public DecoratedTypeMirror getQNameEnumRef() {
        XmlQNameEnumRef enumRef = (XmlQNameEnumRef)this.getAnnotation(XmlQNameEnumRef.class);
        DecoratedTypeMirror qnameEnumType = null;
        if (enumRef != null) {
            try {
                qnameEnumType = TypeMirrorUtils.mirrorOf((Class)enumRef.value(), (ProcessingEnvironment)this.env);
            }
            catch (MirroredTypeException e) {
                qnameEnumType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror(), (DecoratedProcessingEnvironment)this.env);
            }
        }
        return qnameEnumType;
    }

    public LinkedList<Element> getReferencedFrom() {
        LinkedList<Element> stack = new LinkedList<Element>(this.typeDefinition.getReferencedFrom());
        stack.add((Element)((Object)this));
        return stack;
    }

    public EnunciateJacksonContext getContext() {
        return this.context;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }
}

