/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedVariableElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.AccessorVisibilityChecker;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public class AccessorFilter {
    private final EnunciateJacksonContext context;
    private final JsonAutoDetect accessType;
    private final Set<String> propertiesToIgnore;
    private final boolean honorJaxb;
    private final XmlAccessorType jaxbAccessorType;
    private final AccessorVisibilityChecker defaultVisibility;

    public AccessorFilter(EnunciateJacksonContext context, JsonAutoDetect accessType, JsonIgnoreProperties ignoreProperties, XmlAccessorType jaxbAccessorType) {
        this.context = context;
        this.accessType = accessType;
        this.propertiesToIgnore = new TreeSet<String>();
        if (ignoreProperties != null) {
            Collections.addAll(this.propertiesToIgnore, ignoreProperties.value());
        }
        this.honorJaxb = context.isHonorJaxb();
        this.jaxbAccessorType = jaxbAccessorType;
        this.defaultVisibility = context.getDefaultVisibility();
    }

    public boolean accept(DecoratedElement<?> element) {
        String name;
        if (this.context.isIgnored((Element)element)) {
            return false;
        }
        if (element.getAnnotation(JsonProperty.class) != null) {
            return true;
        }
        if (this.honorJaxb) {
            if (element.getAnnotation(XmlTransient.class) != null) {
                return false;
            }
            for (String annotationName : element.getAnnotations().keySet()) {
                if (!annotationName.startsWith("jakarta.xml.bind.annotation")) continue;
                return true;
            }
        }
        if ("".equals(name = element.getSimpleName().toString())) {
            return false;
        }
        if (this.propertiesToIgnore.contains(name)) {
            return false;
        }
        if (element instanceof PropertyElement) {
            PropertyElement property = (PropertyElement)element;
            DecoratedExecutableElement getter = property.getGetter();
            if (getter == null) {
                return false;
            }
            if (!this.isVisible(this.findGetterVisibility(getter), (DecoratedElement)getter)) {
                return false;
            }
            DecoratedExecutableElement setter = property.getSetter();
            return setter == null || this.isVisible(this.findSetterVisibility(), (DecoratedElement)setter);
        }
        if (element instanceof DecoratedVariableElement) {
            if (!this.isVisible(this.findFieldVisibility(), element)) {
                return false;
            }
            return !element.isStatic() && !element.isTransient();
        }
        return false;
    }

    protected JsonAutoDetect.Visibility findFieldVisibility() {
        if (this.accessType != null) {
            return this.accessType.fieldVisibility();
        }
        if (this.honorJaxb && this.jaxbAccessorType != null) {
            switch (this.jaxbAccessorType.value()) {
                case FIELD: {
                    return JsonAutoDetect.Visibility.ANY;
                }
                case NONE: {
                    return JsonAutoDetect.Visibility.NONE;
                }
                case PROPERTY: {
                    return JsonAutoDetect.Visibility.NONE;
                }
                case PUBLIC_MEMBER: {
                    return JsonAutoDetect.Visibility.PUBLIC_ONLY;
                }
            }
        }
        return this.defaultVisibility.getVisibility(PropertyAccessor.FIELD);
    }

    protected JsonAutoDetect.Visibility findSetterVisibility() {
        if (this.accessType != null) {
            return this.accessType.setterVisibility();
        }
        if (this.honorJaxb && this.jaxbAccessorType != null) {
            switch (this.jaxbAccessorType.value()) {
                case FIELD: {
                    return JsonAutoDetect.Visibility.NONE;
                }
                case NONE: {
                    return JsonAutoDetect.Visibility.NONE;
                }
                case PROPERTY: 
                case PUBLIC_MEMBER: {
                    return JsonAutoDetect.Visibility.PUBLIC_ONLY;
                }
            }
        }
        return this.defaultVisibility.getVisibility(PropertyAccessor.SETTER);
    }

    protected JsonAutoDetect.Visibility findGetterVisibility(DecoratedExecutableElement getter) {
        boolean isIsGetter = getter.getSimpleName().toString().startsWith("is");
        if (this.accessType != null) {
            return isIsGetter ? this.accessType.isGetterVisibility() : this.accessType.getterVisibility();
        }
        if (this.honorJaxb && this.jaxbAccessorType != null) {
            switch (this.jaxbAccessorType.value()) {
                case FIELD: {
                    return JsonAutoDetect.Visibility.NONE;
                }
                case NONE: {
                    return JsonAutoDetect.Visibility.NONE;
                }
                case PROPERTY: 
                case PUBLIC_MEMBER: {
                    return JsonAutoDetect.Visibility.PUBLIC_ONLY;
                }
            }
        }
        return this.defaultVisibility.getVisibility(isIsGetter ? PropertyAccessor.IS_GETTER : PropertyAccessor.GETTER);
    }

    protected boolean isVisible(JsonAutoDetect.Visibility visibility, DecoratedElement element) {
        switch (visibility) {
            case ANY: {
                return true;
            }
            case NONE: {
                return false;
            }
            case NON_PRIVATE: {
                return !element.getModifiers().contains((Object)Modifier.PRIVATE);
            }
            case PROTECTED_AND_PUBLIC: {
                return element.getModifiers().contains((Object)Modifier.PROTECTED) || element.getModifiers().contains((Object)Modifier.PUBLIC);
            }
        }
        return element.getModifiers().contains((Object)Modifier.PUBLIC);
    }
}

