/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model.util;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.Converter;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.Accessor;
import com.webcohesion.enunciate.modules.jackson.model.adapters.AdapterType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class JacksonUtil {
    public static final String GSON_SERIALIZED_NAME_CLASS = "com.google.gson.annotations.SerializedName";

    private JacksonUtil() {
    }

    public static DecoratedDeclaredType getNormalizedCollection(DecoratedTypeMirror typeMirror, DecoratedProcessingEnvironment env) {
        List<? extends TypeMirror> typeArgs;
        DecoratedDeclaredType base;
        Object object = typeMirror.isList() ? TypeMirrorUtils.listType((DecoratedProcessingEnvironment)env) : (base = typeMirror.isCollection() || typeMirror.isStream() ? TypeMirrorUtils.collectionType((DecoratedProcessingEnvironment)env) : null);
        if (base != null && (typeArgs = ((DeclaredType)typeMirror).getTypeArguments()).size() == 1) {
            DecoratedTypeMirror componentType = (DecoratedTypeMirror)typeArgs.get(0);
            base = (DecoratedDeclaredType)env.getTypeUtils().getDeclaredType((TypeElement)base.asElement(), new TypeMirror[]{componentType});
        }
        return base;
    }

    public static AdapterType findAdapterType(Element declaration, EnunciateJacksonContext context) {
        if (declaration instanceof Accessor) {
            Accessor accessor = (Accessor)((Object)declaration);
            return JacksonUtil.findAdapterType(accessor.getAccessorType(), (Element)((Object)accessor), context);
        }
        if (declaration instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)declaration;
            return JacksonUtil.findAdapterType((DecoratedTypeMirror)method.getReturnType(), method, context);
        }
        if (declaration instanceof TypeElement) {
            return JacksonUtil.findAdapterType((DecoratedTypeMirror)((DecoratedDeclaredType)declaration.asType()), null, context);
        }
        throw new IllegalArgumentException("A " + declaration.getClass().getSimpleName() + " is not an adaptable declaration according to the JAXB spec.");
    }

    private static AdapterType findAdapterType(DecoratedTypeMirror maybeContainedAdaptedType, Element referer, EnunciateJacksonContext context) {
        JsonSerialize finalInfo;
        DecoratedTypeMirror adapterTypeMirror;
        JsonSerialize serializationInfo;
        DecoratedProcessingEnvironment env = context.getContext().getProcessingEnvironment();
        DecoratedTypeMirror adaptedType = TypeMirrorUtils.getComponentType((DecoratedTypeMirror)maybeContainedAdaptedType, (DecoratedProcessingEnvironment)env);
        boolean isContained = adaptedType != null;
        adaptedType = isContained ? adaptedType : maybeContainedAdaptedType;
        JsonSerialize jsonSerialize = serializationInfo = referer != null ? referer.getAnnotation(JsonSerialize.class) : null;
        if (serializationInfo == null && adaptedType instanceof DeclaredType) {
            serializationInfo = ((DeclaredType)adaptedType).asElement().getAnnotation(JsonSerialize.class);
        }
        if (serializationInfo != null && (adapterTypeMirror = Annotations.mirrorOf(() -> JacksonUtil.lambda$findAdapterType$0(isContained, finalInfo = serializationInfo), (DecoratedProcessingEnvironment)env, Converter.None.class)) instanceof DeclaredType) {
            return new AdapterType((DeclaredType)adapterTypeMirror, context);
        }
        if (context.isHonorJaxb()) {
            XmlJavaTypeAdapter typeAdapterInfo;
            XmlJavaTypeAdapter xmlJavaTypeAdapter = typeAdapterInfo = referer != null ? referer.getAnnotation(XmlJavaTypeAdapter.class) : null;
            if (adaptedType instanceof DeclaredType && typeAdapterInfo == null) {
                typeAdapterInfo = ((DeclaredType)adaptedType).asElement().getAnnotation(XmlJavaTypeAdapter.class);
            }
            if (typeAdapterInfo != null) {
                adapterTypeMirror = Annotations.mirrorOf(() -> ((XmlJavaTypeAdapter)typeAdapterInfo).value(), (DecoratedProcessingEnvironment)env);
                if (adapterTypeMirror instanceof DecoratedDeclaredType) {
                    AdapterType adapterType = new AdapterType((DeclaredType)((DecoratedDeclaredType)adapterTypeMirror), context);
                    if (!context.getContext().getProcessingEnvironment().getTypeUtils().isSameType(adapterType.getAdaptingType(), (TypeMirror)adaptedType)) {
                        return adapterType;
                    }
                }
            }
        }
        return null;
    }

    public static AnnotationValue findAnnotationValueByName(AnnotationMirror am, String name) {
        if (am == null) {
            return null;
        }
        return am.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().toString().equals(name)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public static AnnotationMirror findAnnotationByClassName(List<? extends AnnotationMirror> annos, String className) {
        for (AnnotationMirror annotationMirror : annos) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(className)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static /* synthetic */ Class lambda$findAdapterType$0(boolean isContained, JsonSerialize finalInfo) throws Exception {
        return isContained ? finalInfo.contentConverter() : finalInfo.converter();
    }
}

