/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1.model.types;

import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import com.webcohesion.enunciate.modules.jackson1.model.Accessor;
import com.webcohesion.enunciate.modules.jackson1.model.adapters.Adaptable;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonTypeVisitor;
import com.webcohesion.enunciate.modules.jackson1.model.types.KnownJsonType;
import com.webcohesion.enunciate.modules.jackson1.model.util.MapType;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import javax.lang.model.type.TypeMirror;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class JsonTypeFactory {
    public static JsonType findSpecifiedType(Adaptable adaptable, EnunciateJackson1Context context) {
        JsonType jsonType = null;
        if (adaptable instanceof Accessor) {
            TypeMirror hint;
            Accessor accessor = (Accessor)adaptable;
            TypeHint typeHint = (TypeHint)accessor.getAnnotation(TypeHint.class);
            if (typeHint != null && (hint = TypeHintUtils.getTypeHint((TypeHint)typeHint, (DecoratedProcessingEnvironment)context.getContext().getProcessingEnvironment(), null)) != null) {
                return JsonTypeFactory.getJsonType(hint, context);
            }
            final JsonSerialize serializeInfo = (JsonSerialize)accessor.getAnnotation(JsonSerialize.class);
            if (serializeInfo != null) {
                DecoratedProcessingEnvironment env = context.getContext().getProcessingEnvironment();
                DecoratedTypeMirror using = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws Exception {
                        return serializeInfo.using();
                    }
                }, (DecoratedProcessingEnvironment)env, JsonSerializer.None.class);
                if (using != null) {
                    return KnownJsonType.OBJECT;
                }
                DecoratedTypeMirror as = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws Exception {
                        return serializeInfo.as();
                    }
                }, (DecoratedProcessingEnvironment)env, Void.class);
                if (as != null) {
                    return JsonTypeFactory.getJsonType((TypeMirror)as, context);
                }
                DecoratedTypeMirror contentAs = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws Exception {
                        return serializeInfo.contentAs();
                    }
                }, (DecoratedProcessingEnvironment)env, Void.class);
                DecoratedTypeMirror contentUsing = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws Exception {
                        return serializeInfo.contentUsing();
                    }
                }, (DecoratedProcessingEnvironment)env, JsonSerializer.None.class);
                DecoratedTypeMirror accessorType = (DecoratedTypeMirror)accessor.asType();
                if (accessorType.isCollection() || accessorType.isArray() || accessorType.isStream()) {
                    if (contentUsing != null) {
                        return new JsonArrayType(KnownJsonType.OBJECT);
                    }
                    if (contentAs != null) {
                        return new JsonArrayType(JsonTypeFactory.getJsonType((TypeMirror)contentAs, context));
                    }
                } else {
                    MapType mapType = MapType.findMapType((TypeMirror)accessorType, context);
                    if (mapType != null) {
                        DecoratedTypeMirror keyAs = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                            @Override
                            public Class<?> call() throws Exception {
                                return serializeInfo.keyAs();
                            }
                        }, (DecoratedProcessingEnvironment)env, Void.class);
                        DecoratedTypeMirror keyUsing = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                            @Override
                            public Class<?> call() throws Exception {
                                return serializeInfo.keyUsing();
                            }
                        }, (DecoratedProcessingEnvironment)env, JsonSerializer.None.class);
                        if (keyAs != null || contentAs != null) {
                            KnownJsonType keyType;
                            JsonType jsonType2 = keyUsing == null ? JsonTypeFactory.getJsonType((TypeMirror)(keyAs == null ? (DecoratedTypeMirror)mapType.getKeyType() : keyAs), context) : (keyType = KnownJsonType.OBJECT);
                            KnownJsonType valueType = contentUsing == null ? JsonTypeFactory.getJsonType((TypeMirror)(contentAs == null ? (DecoratedTypeMirror)mapType.getValueType() : contentAs), context) : KnownJsonType.OBJECT;
                            return new JsonMapType(keyType, valueType);
                        }
                    }
                }
            }
        }
        if (adaptable.isAdapted()) {
            jsonType = JsonTypeFactory.getJsonType(adaptable.getAdapterType().getAdaptingType(), context);
        }
        return jsonType;
    }

    public static JsonType getJsonType(TypeMirror typeMirror, EnunciateJackson1Context context) {
        return typeMirror.accept(new JsonTypeVisitor(), new JsonTypeVisitor.Context(context, false, false, new LinkedList<String>()));
    }
}

